% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JDSI.R
\name{JDSI}
\alias{JDSI}
\title{Compute the multivariate drought index with joint distribution}
\usage{
JDSI(X, Y, ts = 6, type = 1)
}
\arguments{
\item{X}{is The vector of a monthly hydro-climatic variable of n years.}

\item{Y}{is The vector of a monthly hydro-climatic variable of n years.}

\item{ts}{is the accumulated time scale.}

\item{type}{is the method used to compute the JDSI (1 is Joint distribution and 2 is the Kendall function).}
}
\value{
The multivariate drought index of different time scales from the marginal probability (or percentile)
}
\description{
Compute the multivariate drought index with joint distribution
}
\examples{
X=runif(120, min = 0, max = 100)
Y=runif(120, min = 0, max = 100)
fit<-JDSI(X,Y,ts=6)  
z=matrix(t(fit$JDSI),ncol=1)
plot(z, type="l", col=1, lwd=2, lty=1, xlim=c(0,120),xlab="Time",ylab="JDSI")
}
