% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-predict.R
\name{predict_runtime}
\alias{predict_runtime}
\title{Predict the elapsed runtime of the next call to \code{make()}
for non-staged parallel backends.}
\usage{
predict_runtime(config, targets = NULL, from_scratch = FALSE,
  targets_only = NULL, jobs = 1, known_times = numeric(0),
  default_time = 0, warn = TRUE)
}
\arguments{
\item{config}{Optional internal runtime parameter list of
produced by both \code{\link[=make]{make()}} and
\code{\link[=drake_config]{drake_config()}}.}

\item{targets}{Character vector, names of targets.
Predict the runtime of building these targets
plus dependencies.
Defaults to all targets.}

\item{from_scratch}{Logical, whether to predict a
\code{\link[=make]{make()}} build from scratch or to
take into account the fact that some targets may be
already up to date and therefore skipped.}

\item{targets_only}{Deprecated.}

\item{jobs}{The \code{jobs} argument of your next planned
\code{make()}. How many targets to do you plan
to have running simultaneously?}

\item{known_times}{A named numeric vector with targets/imports
as names and values as hypothetical runtimes in seconds.
Use this argument to overwrite any of the existing build times
or the \code{default_time}.}

\item{default_time}{Number of seconds to assume for any
target or import with no recorded runtime (from \code{\link[=build_times]{build_times()}})
or anything in \code{known_times}.}

\item{warn}{Logical, whether to warn the user about
any targets with no available runtime, either in
\code{known_times} or \code{\link[=build_times]{build_times()}}. The times for these
targets default to \code{default_time}.}
}
\value{
Predicted total runtime of the next call to \code{\link[=make]{make()}}.
}
\description{
Take the past recorded runtimes times from
\code{\link[=build_times]{build_times()}} and use them to predict how the targets
will be distributed among the available workers in the
next \code{\link[=make]{make()}}. Then, predict the overall runtime to be the
runtime of the slowest (busiest) workers.
Predictions only include the time it takes to run the targets,
not overhead/preprocessing from \code{drake} itself.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
config <- drake_config(my_plan)
known_times <- rep(7200, nrow(my_plan))
names(known_times) <- my_plan$target
known_times
# Predict the runtime
if (requireNamespace("lubridate", quietly = TRUE)) {
predict_runtime(
  config,
  jobs = 7,
  from_scratch = TRUE,
  known_times = known_times
)
predict_runtime(
  config,
  jobs = 8,
  from_scratch = TRUE,
  known_times = known_times
)
balance <- predict_workers(
  config,
  jobs = 7,
  from_scratch = TRUE,
  known_times = known_times
)
balance
}
}
})
}
}
\seealso{
\code{\link[=predict_workers]{predict_workers()}}, \code{\link[=build_times]{build_times()}}, \code{\link[=make]{make()}}
}
