drake_context("hash tables")

test_with_dir("hash tables work", {
  e <- ht_new()
  expect_equal(ht_list(e), character(0))
  expect_false(ht_exists(e, "a"))
  expect_false(ht_exists(e, "b"))
  ht_set(e, c("a", "b"))
  expect_true(ht_exists(e, "a"))
  expect_true(ht_exists(e, "b"))
  ht_del(e, "a")
  expect_false(ht_exists(e, "a"))
  expect_true(ht_exists(e, "b"))
  expect_equal(ht_list(e), "b")
  f <- ht_clone(e)
  ht_set(f, "xyz")
  expect_false(ht_exists(e, "xyz"))
  expect_true(ht_exists(f, "xyz"))
  ht_del(f, "xyz")
  expect_false(ht_exists(f, "xyz"))
  g <- ht_new("x")
  expect_true(all(ht_exists(g, "x")))
  x <- ht_new(c("a", "b"))
  y <- ht_new(c("b", "c", "d"))
  ht_merge(x, y)
  expect_equal(sort(ht_list(x)), sort(c("a", "b", "c", "d")))
  expect_equal(sort(ht_list(y)), sort(c("b", "c", "d")))
  ht_clear(y)
  expect_equal(ht_list(y), character(0))
})

test_with_dir("hash-table-based memoization", {
  skip_if_not_installed("tibble")
  f <- function(x) {
    file.create(x)
    x
  }
  ht_memo(NULL, x = "a", fun = f)
  expect_true(file.exists("a"))
  unlink("a")
  expect_false(file.exists("a"))
  ht_memo(NULL, x = "a", fun = f)
  expect_true(file.exists("a"))
  ht <- ht_new()
  ht_memo(ht, x = "a", fun = f)
  expect_true(file.exists("a"))
  unlink("a")
  expect_false(file.exists("a"))
  ht_memo(ht, x = "a", fun = f)
  expect_false(file.exists("a"))
})
