% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec-dependencies.R
\name{deps_profile}
\alias{deps_profile}
\title{Find out why a target is out of date.}
\usage{
deps_profile(target, config, character_only = FALSE)
}
\arguments{
\item{target}{Name of the target.}

\item{config}{Configuration list output by
\code{\link[=drake_config]{drake_config()}} or \code{\link[=make]{make()}}.}

\item{character_only}{Logical, whether to assume \code{target}
is a character string rather than a symbol.}
}
\value{
A data frame of the old hashes and
new hashes of the data frame, along with
an indication of which hashes changed since
the last \code{\link[=make]{make()}}.
}
\description{
The dependency profile can give you
a hint as to why a target is out of date.
It can tell you if
\itemize{
\item at least one input file changed,
\item at least one output file changed,
\item or a non-file dependency changed. For this last part,
the imports need to be up to date in the cache,
which you can do with \code{outdated()} or
\code{make(skip_targets = TRUE)}.
Unfortunately, \code{deps_profile()} does not
currently get more specific than that.
}
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Load drake's canonical example.
make(my_plan) # Run the project, build the targets.
config <- drake_config(my_plan)
# Get some example dependency profiles of targets.
deps_profile(small, config = config)
# Change a dependency.
simulate <- function(x) {}
# Update the in-memory imports in the cache
# so deps_profile can detect changes to them.
# Changes to targets are already cached.
make(my_plan, skip_targets = TRUE)
# The dependency hash changed.
deps_profile(small, config = config)
}
})
}
}
\seealso{
\code{\link[=diagnose]{diagnose()}},
\code{\link[=deps_code]{deps_code()}}, \code{\link[=make]{make()}},
\code{\link[=drake_config]{drake_config()}}
}
