% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-times.R
\name{build_times}
\alias{build_times}
\title{List the time it took to build each target.}
\usage{
build_times(..., path = getwd(), search = TRUE, digits = 3,
  cache = get_cache(path = path, search = search, verbose = verbose),
  targets_only = NULL, verbose = 1L, jobs = 1, type = c("build",
  "command"))
}
\arguments{
\item{...}{Targets to load from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{digits}{How many digits to round the times to.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{targets_only}{Deprecated.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{type}{Type of time you want: either \code{"build"}
for the full build time including the time it took to
store the target, or \code{"command"} for the time it took
just to run the command.}
}
\value{
A data frame of times, each from \code{\link[=system.time]{system.time()}}.
}
\description{
Applies to targets in your plan, not imports or files.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
if (requireNamespace("lubridate")) {
# Show the build times for the mtcars example.
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Build all the targets.
print(build_times()) # Show how long it took to build each target.
}
}
})
}
}
\seealso{
\code{\link[=predict_runtime]{predict_runtime()}}
}
