% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks.R
\name{silencer_hook}
\alias{silencer_hook}
\title{An example \code{hook} argument to
\code{make()} that redirects output and error messages}
\usage{
silencer_hook(code)
}
\arguments{
\item{code}{code to run to build the target.}
}
\value{
A function that you can supply to the \code{hook} argument
of \code{\link[=make]{make()}}.
}
\description{
Most users do not need to micromanage hooks.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# Test out the silencer hook on its own.
try(
  silencer_hook({
    cat(1234)
    stop(5678)
  }),
  silent = FALSE
)
# Make a new workflow plan.
x <- drake_plan(loud = cat(1234), bad = stop(5678))
# Test out the silencer hook on a drake project.
# All output should be suppressed.
try(make(x, hook = silencer_hook), silent = FALSE)
})
}
}
\seealso{
\code{\link[=make]{make()}}, \code{\link[=message_sink_hook]{message_sink_hook()}},
\code{\link[=output_sink_hook]{output_sink_hook()}}
}
