% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_example.R
\name{load_basic_example}
\alias{load_basic_example}
\title{Load the basic example from \code{drake_example("basic")}}
\usage{
load_basic_example(envir = parent.frame(), seed = NULL, cache = NULL,
  report_file = "report.Rmd", overwrite = FALSE, to = report_file,
  verbose = drake::default_verbose(), force = FALSE)
}
\arguments{
\item{envir}{The environment to load the example into.
Defaults to your workspace.
For an insulated workspace,
set \code{envir = new.env(parent = globalenv())}.}

\item{seed}{integer, the root pseudo-random seed to use for your project.
To ensure reproducibility across different R sessions,
\code{set.seed()} and \code{.Random.seed} are ignored and have no affect on
\code{drake} workflows. Conversely, \code{\link[=make]{make()}} does not change \code{.Random.seed},
even when pseudo-random numbers are generated.

On the first call to \code{\link[=make]{make()}} or \code{\link[=drake_config]{drake_config()}}, \code{drake}
uses the random number generator seed from the \code{seed} argument.
Here, if the \code{seed} is \code{NULL} (default), \code{drake} uses a \code{seed} of \code{0}.
On subsequent \code{\link[=make]{make()}}s for existing projects, the project's
cached seed will be used in order to ensure reproducibility.
Thus, the \code{seed} argument must either be \code{NULL} or the same
seed from the project's cache (usually the \code{.drake/} folder).
To reset the random number generator seed for a project,
use \code{clean(destroy = TRUE)}.}

\item{cache}{Optional \code{storr} cache to use.}

\item{report_file}{where to write the report file \code{report.Rmd}.}

\item{overwrite}{logical, whether to overwrite an
existing file \code{report.Rmd}}

\item{to}{deprecated, where to write the dynamic report source file
\code{report.Rmd}}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}

\item{force}{logical, whether to force the loading of a
non-back-compatible cache from a previous version of drake.}
}
\value{
A \code{\link[=drake_config]{drake_config()}} configuration list.
}
\description{
Is there an association between
the weight and the fuel efficiency of cars?
To find out, we use the mtcars dataset.
The mtcars dataset itself only has 32 rows,
so we generate two larger bootstrapped datasets
and then analyze them with regression models.
Finally, we summarize the regression models
to see if there is an association.
}
\details{
Use \code{\link{drake_example}("basic")} to get the code
for the basic example. The included R script is a detailed,
heavily-commented walkthrough. The basic example vignette at
\url{https://github.com/ropensci/drake/blob/master/vignettes/example-basic.Rmd} # nolint
also walks through the basic example.
This function also writes/overwrites
the file, \code{report.Rmd}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# Populate your workspace and write 'report.Rmd'.
load_basic_example() # Get the code: drake_example("basic")
# Check the dependencies of an imported function.
deps(reg1)
# Check the dependencies of commands in the workflow plan.
deps(my_plan$command[1])
deps(my_plan$command[4])
# Plot the interactive network visualization of the workflow.
config <- drake_config(my_plan)
vis_drake_graph(config)
# Run the workflow to build all the targets in the plan.
make(my_plan)
# For the reg2() model on the small dataset,
# the p-value is so small that there may be an association
# between weight and fuel efficiency after all.
readd(coef_regression2_small)
# Remove the whole cache.
clean(destroy = TRUE)
# Clean up the imported file.
unlink("report.Rmd")
})
}
}
