% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{pull}
\alias{pull}
\title{Pull out a single variable}
\usage{
pull(.data, var = -1)
}
\arguments{
\item{.data}{A table of data}

\item{var}{A variable specified as:
\itemize{
\item a literal variable name
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last column (on the assumption that's the
column you've created most recently).

This argument is taken by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names and column positions).}
}
\description{
This works like \code{[[} for local data frames, and automatically collects
before indexing for remote data tables.
}
\examples{
mtcars \%>\% pull(-1)
mtcars \%>\% pull(1)
mtcars \%>\% pull(cyl)

# Also works for remote sources
if (requireNamespace("dbplyr", quietly = TRUE)) {
df <- dbplyr::memdb_frame(x = 1:10, y = 10:1, .name = "pull-ex")
df \%>\%
  mutate(z = x * y) \%>\%
  pull()
}

}
