% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-vars.R
\name{select_vars}
\alias{rename_vars}
\alias{rename_vars_}
\alias{select_vars}
\alias{select_vars_}
\title{Select variables.}
\usage{
select_vars(vars, ..., include = character(), exclude = character())

select_vars_(vars, args, include = character(), exclude = character())

rename_vars(vars, ...)

rename_vars_(vars, args)
}
\arguments{
\item{vars}{A character vector of existing column names.}

\item{..., args}{Expressions to compute. \code{select_vars} and
\code{rename_vars}}

\item{include, exclude}{Character vector of column names to always
include/exclude.}
}
\value{
A named character vector. Values are existing column names,
  names are new names.
}
\description{
These functions power \code{\link{select}()} and \code{\link{rename}()}.
}
\examples{
# Keep variables
select_vars(names(iris), everything())
select_vars(names(iris), starts_with("Petal"))
select_vars(names(iris), ends_with("Width"))
select_vars(names(iris), contains("etal"))
select_vars(names(iris), matches(".t."))
select_vars(names(iris), Petal.Length, Petal.Width)
select_vars(names(iris), one_of("Petal.Length", "Petal.Width"))

df <- as.data.frame(matrix(runif(100), nrow = 10))
df <- df[c(3, 4, 7, 1, 9, 8, 5, 2, 6, 10)]
select_vars(names(df), num_range("V", 4:6))

# Drop variables
select_vars(names(iris), -starts_with("Petal"))
select_vars(names(iris), -ends_with("Width"))
select_vars(names(iris), -contains("etal"))
select_vars(names(iris), -matches(".t."))
select_vars(names(iris), -Petal.Length, -Petal.Width)

# Rename variables
select_vars(names(iris), petal_length = Petal.Length)
select_vars(names(iris), petal = starts_with("Petal"))

# Rename variables preserving all existing
rename_vars(names(iris), petal_length = Petal.Length)

# Standard evaluation -------------------------------------------------------
# You can use names, calls, formulas (or lists of), or a character vector
select_vars_(names(iris), list(~Petal.Length))
select_vars_(names(iris), list(quote(Petal.Length)))
select_vars_(names(iris), "Petal.Length")
}
\keyword{internal}

