% Generated by roxygen2 (4.0.2): do not edit by hand
\name{test_counts}
\alias{test_counts}
\title{Test counts}
\usage{
test_counts(input, ...)
}
\arguments{
\item{input}{adpcr or dpcr object with with "nm" type.}

\item{...}{additional arguments for \code{\link{glm}} function.}
}
\value{
an object of class
}
\description{
The test for comparing counts from two or more digital PCR experiments.
}
\details{
\code{test_counts} fits General Linear Model (using Poisson
\code{\link[stats]{family}}) to the counts data from different digital PCR experiments.
Comparisions between single experiments utilize Tukey's contrast and multiple
t-tests using function \code{\link{glht}}.
}
\note{
Mean values of Poisson distribution are derived from General Linear Models. They values
will vary depending on input.
}
\examples{
adpcr1 <- sim_adpcr(m = 10, n = 765, times = 1000, pos_sums = FALSE, n_panels = 3)
adpcr2 <- sim_adpcr(m = 60, n = 550, times = 1000, pos_sums = FALSE, n_panels = 3)
adpcr3 <- sim_adpcr(m = 10, n = 600, times = 1000, pos_sums = FALSE, n_panels = 3)
two_groups <- test_counts(bind_dpcr(adpcr1, adpcr2))
summary(two_groups)
plot(two_groups)
one_group <- test_counts(bind_dpcr(adpcr1, adpcr3))
summary(one_group)
plot(one_group)
}
\author{
Michal Burdukiewicz, Stefan Roediger
}

