% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{blup.dosresmeta}
\alias{blup.dosresmeta}
\title{Best Linear Unbiased Predictions from dosresmeta Models}
\usage{
\method{blup}{dosresmeta}(object, ...)
}
\arguments{
\item{object}{objects of classe "\code{dosresmeta}".}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
This method function computes (empirical) best linear unbiased predictions 
from fitted dose-response meta-analytical models represented in objects of class "dosresemta".
}
\details{
The method function blup produces (empirical) best linear unbiased predictions from dosresmeta objects. 
Predictions are expressed in terms of study-specific deviations as random effects.
Predicted random effects from blup are a shrunk version of study-specific realizations, where study-specific predictions borrow 
strength from the assumption of an underlying distribution in a (usually hypothetical) population of studies.
Blup are not avaialable for fixed-effects models since the are meaningless in that context.
}
\examples{
## Load data and run the linear and quadratic models
data("alcohol_cvd")
lin <- dosresmeta(formula = logrr ~ dose, type = type, id = id,
                  se = se, cases = cases, n = n, data = alcohol_cvd) 
quadr <- dosresmeta(formula = logrr ~ dose + I(dose^2), type = type, id = id,
                    se = se, cases = cases, n = n, data = alcohol_cvd) 

## blup prediction for the previous models
blup(lin)
blup(quadr)

}
