% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fund-cycles.R
\name{dodgr_full_cycles}
\alias{dodgr_full_cycles}
\title{dodgr_full_cycles}
\usage{
dodgr_full_cycles(graph, graph_max_size = 10000, expand = 0.05)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the contracted
network graph (see Details).}

\item{graph_max_size}{Maximum size submitted to the internal C++ routines as
a single chunk. Warning: Increasing this may lead to computer meltdown!}

\item{expand}{For large graphs which must be broken into chunks, this factor
determines the relative overlap between chunks to ensure all cycles are
captured. (This value should only need to be modified in special cases.)}
}
\description{
Calculate fundamental cycles on a FULL (that is, non-contracted) graph.
}
\note{
This function converts the \code{graph} to its contracted form, calculates
the fundamental cycles on that version, and then expands these cycles back
onto the original graph. This is far more computationally efficient than
calculating fundamental cycles on a full (non-contracted) graph.
}
\examples{
\dontrun{
net <- weight_streetnet (hampi)
graph <- dodgr_contract_graph (net)
cyc1 <- dodgr_fundamental_cycles (graph)
cyc2 <- dodgr_full_cycles (net)
}
# cyc2 has same number of cycles, but each one is generally longer, through
# including all points intermediate to junctions; cyc1 has cycles composed of
# junction points only.
}
