% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{FedorovWynn}
\alias{FedorovWynn}
\title{Fedorov Wynn}
\usage{
FedorovWynn(sensF, tol = 1e-04, maxIter = 10000)
}
\arguments{
\item{sensF}{\code{function(x=NULL, desw=NULL, desx=NULL, mod=NULL)}, a sensitivity function. It's attribute \code{"defaults"} shall contain \code{x} and \code{sensF(desw=w)} shall return sensitivities for each point in \code{x} respectively for some \code{w}.}

\item{tol}{the tolerance level regarding the sensitivities.}

\item{maxIter}{the maximum number of iterations.}
}
\value{
\code{FedorovWynn} returns an object of \code{class} \code{"desigh"}.
See \code{design} for its structural definition.
}
\description{
\code{FedorovWynn} finds an optimal design using some sensitivity function and a Fedorov-Wynn-type algorithm.
}
\details{
See \code{Dsensitivity} and it's return value for a reference implementation of a function complying with the requirements for \code{sensF}.

The algorithm starts from a uniform weight design.
In each iteration weight is redistributed to the point which has the highest sensitivity.
Sequence: \code{1/i}.
The algorithm stops when all sensitivities are below a specified tolerance level or the maximum number of iterations is reached.
}
\examples{
## see examples for param
}
\references{
Fedorov, V. V. (1971) The Design of Experiments in the Multiresponse Case.
\emph{Theory of Probability and its Applications}, 16(2):323-332.

Wynn, Henry P. (1970) The Sequential Generation of D-Optimum Experimental Designs.
\emph{The Annals of Mathematical Statistics}, 41(5):1655-1664.
}
\seealso{
\code{\link{Dsensitivity}}, \code{\link{design}}
}

