% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{get_networks}
\alias{get_networks}
\title{Get the two association networks}
\usage{
get_networks(x)
}
\arguments{
\item{x}{A 'dnapath' object from \code{\link{dnapath}}.}
}
\value{
A list of two association matrices.
}
\description{
Extracts the estimated association network for each group from the
differential network analysis results.
}
\note{
The two matrices can be plotted using the
\code{\link[SeqNet]{plot_network}} function from the SeqNet package, as
illustrated in the examples below.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 10)
# Extract the two estimated association networks for the first pathway
nw <- get_networks(results[[1]])
# Plot the networks using the SeqNet::plot_network function.
# Note that the `compare_graph` argument is used so that the same node layout
# is used across all of the plots.
# Plot the two networks (in separate plots)
g <- SeqNet::plot_network(nw[[1]])
SeqNet::plot_network(nw[[1]], compare_graph = g)
# Plot of the differential network for pathway 1.
# Again, the `compare_graph` argument is used to maintain the same layout.
plot(results[[1]], compare_graph = g) 
# We see that genes 51230 and 7311 show strong differential connectivity.
# The plot_pair() function can be used to investigate these two genes further.
plot_pair(results[[1]], "51230", "7311")
}
