% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_new_spreadsheet.R
\name{open_new_spreadsheet}
\alias{open_new_spreadsheet}
\title{Open the metadata scheme as a spreadsheet in a spreadsheet editor}
\usage{
open_new_spreadsheet(
  file = NULL,
  open = TRUE,
  keepData = FALSE,
  format = TRUE,
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{if not \code{NULL}, the template will be saved to this file.}

\item{open}{if \code{TRUE}, the file will be opened. This can produce different results depending on the OS, browsr and browser settings.}

\item{keepData}{if \code{TRUE} the data entry areas will be emptied. If \code{FALSE}. the example data will be included.}

\item{format}{if \code{FALSE} the sheet will be opened as the sheet is. if \code{TRUE}, it will be formated nicely.}

\item{overwrite}{if \code{TRUE}, the file specified in \code{file} will be overwritten. if \code{FALSE}, an error will be raised ehen the file exists.}

\item{verbose}{give verbose progress info. Useful for debugging.}
}
\value{
invisibly the fully qualified path to the file which \bold{would} have been opened, if \code{open == TRUE}.
}
\description{
Open \code{system.file(paste0(schemeName, ".xlsx"), package = schemeName)} in excel.
New data can be entered and the file has to be saved at a different location
as it is a read-only file.
}
\examples{
\dontrun{
open_new_spreadsheet(schemeName = "dmdScheme", format = FALSE, verbose = TRUE)
}

}
