% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-interface.R
\name{copy_dm_to}
\alias{copy_dm_to}
\title{Copy data model to data source}
\usage{
copy_dm_to(
  dest,
  dm,
  ...,
  types = NULL,
  overwrite = NULL,
  indexes = NULL,
  unique_indexes = NULL,
  set_key_constraints = TRUE,
  unique_table_names = NULL,
  table_names = NULL,
  temporary = TRUE
)
}
\arguments{
\item{dest}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{dm}{A \code{dm} object.}

\item{...}{Passed on to \code{\link[dplyr:copy_to]{dplyr::copy_to()}}, which is used on each table.}

\item{overwrite, types, indexes, unique_indexes}{Must remain \code{NULL}.}

\item{set_key_constraints}{Boolean variable, if \code{TRUE} will mirror \code{dm} key constraints on a database.}

\item{unique_table_names}{Deprecated.}

\item{table_names}{Desired names for the tables on \code{dest}; the names within the \code{dm} remain unchanged.
Can be \code{NULL}, a named character vector, a function or a one-sided formula.

If left \code{NULL} (default), the names will be determined automatically depending on the \code{temporary} argument:
\enumerate{
\item \code{temporary = TRUE} (default): unique table names based on the names of the tables in the \code{dm} are created.
\item \code{temporary = FALSE}: the table names in the \code{dm} are used as names for the tables on \code{dest}.
}

If a function or one-sided formula, \code{table_names} is converted to a function
using \code{\link[rlang:as_function]{rlang::as_function()}}.
This function is called with the unquoted table names of the \code{dm} object
as the only argument.
The output of this function is processed by \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}},
that result should be a vector of identifiers of the same length
as the original table names.

Use a variant of
\code{table_names = ~ DBI::SQL(dbplyr::in_schema("schema_name", .x))}
to specify the same schema for all tables.
Use \code{table_names = identity} with \code{temporary = TRUE}
to avoid giving temporary tables unique names.

If a named character vector,
the names of this vector need to correspond to the table names in the \code{dm},
and its values are the desired names on \code{dest}.
The value is processed by \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}},
that result should be a vector of identifiers of the same length
as the original table names.

Use qualified names corresponding to your database's syntax
to specify e.g. database and schema for your tables.}

\item{temporary}{Boolean variable, if \code{TRUE}, only temporary tables will be created.
These tables will vanish when disconnecting from the database.}
}
\value{
A \code{dm} object on the given \code{src} with the same table names
as the input \code{dm}.
}
\description{
\code{copy_dm_to()} takes a \link[dplyr:src_dbi]{dplyr::src_dbi} object or a \code{\link[DBI:DBIConnection-class]{DBI::DBIConnection}} object as its first argument
and a \code{\link{dm}} object as its second argument.
The latter is copied to the former.
By default, temporary tables will be created and the key constraints will be set
(currently only on MSSQL and Postgres databases).
}
\details{
No tables will be overwritten; passing \code{overwrite = TRUE} to the function will give an error.
Types are determined separately for each table, setting the \code{types} argument will
also throw an error.
The arguments are included in the signature to avoid passing them via the
\code{...} ellipsis.
}
\examples{
\dontshow{if (rlang::is_installed("RSQLite") && rlang::is_installed("nycflights13") && rlang::is_installed("dbplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- DBI::dbConnect(RSQLite::SQLite())

# Copy to temporary tables, unique table names by default:
temp_dm <- copy_dm_to(
  con,
  dm_nycflights13(),
  set_key_constraints = FALSE
)

# Persist, explicitly specify table names:
persistent_dm <- copy_dm_to(
  con,
  dm_nycflights13(),
  temporary = FALSE,
  table_names = ~ paste0("flights_", .x)
)
dbplyr::remote_name(persistent_dm$planes)

DBI::dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\concept{DB interaction functions}
