% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{plot.compare_category}
\alias{plot.compare_category}
\title{Visualize Information for an "compare_category" Object}
\usage{
\method{plot}{compare_category}(
  x,
  prompt = FALSE,
  na.rm = FALSE,
  typographic = TRUE,
  base_family = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class "compare_category", usually, a result of a call to compare_category().}

\item{prompt}{logical. The default value is FALSE. If there are multiple visualizations to be output, if this argument value is TRUE, a prompt is output each time.}

\item{na.rm}{logical. Specifies whether to include NA when plotting mosaics plot. 
The default is FALSE, so plot NA.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
However, it only support las parameter. las is numeric in {0,1}; the style of axis labels.
\itemize{
  \item 0 : always parallel to the axis [default],
  \item 1 : always horizontal to the axis,
}}
}
\description{
Visualize mosaics plot by attribute of compare_category class.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

library(dplyr)

# Compare the all categorical variables
all_var <- compare_category(heartfailure2)

# Print compare_numeric class objects
all_var

# Compare the two categorical variables
two_var <- compare_category(heartfailure2, smoking, death_event)

# Print compare_category class objects
two_var

# plot all pair of variables
# plot(all_var)

# plot a pair of variables
plot(two_var)

# plot all pair of variables by prompt
# plot(all_var, prompt = TRUE)
  
# plot a pair of variables without NA
# plot(two_var, na.rm = TRUE)

# plot a pair of variables
# plot(two_var, las = 1)

# plot a pair of variables not focuses on typographic elements
# plot(two_var, typographic = FALSE)

}
\seealso{
\code{\link{compare_category}}, \code{\link{print.compare_category}}, \code{\link{summary.compare_category}}.
}
