% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{tsplot}
\alias{tsplot}
\title{Time series plotting using a custom time scale}
\usage{
tsplot(tsdat, boxes = NULL, ylim = c(0, 1), xlim = NULL, prop = 0.05,
  gap = 0, bottom = "bottom", top = "top", xlab = "age (Ma)",
  ylab = "", shading = NULL, shading.col = c("white", "gray80"),
  plot.args = NULL, boxes.args = NULL, labels.args = NULL)
}
\arguments{
\item{tsdat}{\code{(data frame)}: The time scale data frame.}

\item{boxes}{\code{(character)}: Column name indicating the names that should be plotted as boxes of the timescale.}

\item{ylim}{\code{(numeric)}: The vertical extent of the plot, analogous to the same argument of \code{\link[graphics]{plot}}. By default it is set to the \code{[0,1]} interval.}

\item{xlim}{\code{(numeric)}: The horizontal extent of the plot, analogous to the same argument of \code{\link[graphics]{plot}}. By default it is set to plot the entire table. If a numeric vector with two values is supplied, it will be interpreted as the standard \code{xlim} argument and the plot will be displayed based on numerically constrained ages. If it is an integer vector with more than two values are plotted, the interval corresponding to the row indices of the table will be plotted.}

\item{prop}{\code{(numeric)}: Proportion of the vertical extent of the plot to display the the time scale at the bottom.}

\item{gap}{\code{(numeric)}: Proportion of the vertical extent of the plot that should be a gap betwen the time scale and the plot.}

\item{bottom}{\code{(character)}: Column name of the table for the variable that contains the older ages of intervals.}

\item{top}{\code{(character)}: Column name of the table for the variable that contains the earliest ages of intervals.}

\item{xlab}{\code{(character)}: The label of the time axis.}

\item{ylab}{\code{(character)}: The label of the data axis.}

\item{shading}{\code{(character)}: Column name used for the shading. By default, no shading will be drawn (\code{shading = NULL}).}

\item{shading.col}{\code{(character)}: Name of colors that will be used for the shading, if shading is set. The provided colors will be repeated as many times as necessary.}

\item{plot.args}{\code{(list)}: Arguments that will be passed to the main \code{\link[graphics]{plot}} function.  Can be useful for the suppression of axes, font change etc.}

\item{boxes.args}{\code{(list)}: Arguments that will be passed to the \code{\link[graphics]{rect}} function that draws the rectangles of time intervals.}

\item{labels.args}{\code{(list)}: Arguments that will be passed to the \code{\link[graphics]{text}} function that draws the labels.}
}
\description{
This function allows the user to quickly plot a time scale data table
}
\details{
As most analysis use an individually compiled time scale object, in order to ensure compatibility between the analyzed and plotted values, the time scale table used for the analysis could be plotted rather than a standardized table. Two example tables have been included in the package (\code{\link{stages}} and \code{\link{bins}}) that can serve as templates.
}
\examples{
data(stages) 
  tsplot(stages, boxes="per", shading="series")

# only the Mesozoic, custom axes
  tsplot(stages, boxes="period", shading="stage", xlim=52:81, 
    plot.args=list(axes=FALSE, main="Mesozoic"))
  axis(1, at=seq(250, 75, -25), labels=seq(250, 75, -25))
  axis(2)

# only the Triassic, use the supplied abbreviations
  tsplot(stages, boxes="short", shading="stage", xlim=c(250,199), 
    ylab="variable", labels.args=list(cex=1.5, col="blue"), 
    boxes.args=list(col="gray95"))
}
