% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonBinomial.R
\name{pdf.PoissonBinomial}
\alias{pdf.PoissonBinomial}
\alias{log_pdf.PoissonBinomial}
\title{Evaluate the probability mass function of a PoissonBinomial distribution}
\usage{
\method{pdf}{PoissonBinomial}(d, x, drop = TRUE, elementwise = NULL, log = FALSE, verbose = TRUE, ...)

\method{log_pdf}{PoissonBinomial}(d, x, drop = TRUE, elementwise = NULL, ...)
}
\arguments{
\item{d}{A \code{PoissonBinomial} object created by a call to \code{\link[=PoissonBinomial]{PoissonBinomial()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{elementwise}{logical. Should each distribution in \code{d} be evaluated
at all elements of \code{x} (\code{elementwise = FALSE}, yielding a matrix)?
Or, if \code{d} and \code{x} have the same length, should the evaluation be
done element by element (\code{elementwise = TRUE}, yielding a vector)? The
default of \code{NULL} means that \code{elementwise = TRUE} is used if the
lengths match and otherwise \code{elementwise = FALSE} is used.}

\item{log, ...}{Arguments to be passed to \code{\link[PoissonBinomial]{dpbinom}}
or \code{\link[stats]{pnorm}}, respectively.}

\item{verbose}{logical. Should a warning be issued if the normal approximation
is applied because the \pkg{PoissonBinomial} package is not installed?}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the probability mass function of a PoissonBinomial distribution
}
\examples{

set.seed(27)

X <- PoissonBinomial(0.5, 0.3, 0.8)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.8)

cdf(X, quantile(X, 0.8))
quantile(X, cdf(X, 2))

## equivalent definitions of four Poisson binomial distributions
## each summing up three Bernoulli probabilities
p <- cbind(
  p1 = c(0.1, 0.2, 0.1, 0.2),
  p2 = c(0.5, 0.5, 0.5, 0.5),
  p3 = c(0.8, 0.7, 0.9, 0.8))
PoissonBinomial(p)
PoissonBinomial(p[, 1], p[, 2], p[, 3])
PoissonBinomial(p[, 1:2], p[, 3])
}
