% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormal.R
\name{quantile.LogNormal}
\alias{quantile.LogNormal}
\title{Determine quantiles of a LogNormal distribution}
\usage{
\method{quantile}{LogNormal}(d, p, ...)
}
\arguments{
\item{d}{A \code{LogNormal} object created by a call to \code{\link[=LogNormal]{LogNormal()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
Determine quantiles of a LogNormal distribution
}
\examples{

set.seed(27)

X <- LogNormal(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other LogNormal distribution: \code{\link{cdf.LogNormal}},
  \code{\link{fit_mle.LogNormal}},
  \code{\link{pdf.LogNormal}},
  \code{\link{random.LogNormal}}
}
\concept{LogNormal distribution}
