% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cauchy.R
\name{quantile.Cauchy}
\alias{quantile.Cauchy}
\title{Determine quantiles of a Cauchy distribution}
\usage{
\method{quantile}{Cauchy}(d, p, ...)
}
\arguments{
\item{d}{A \code{Cauchy} object created by a call to \code{\link[=Cauchy]{Cauchy()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Cauchy(10, 0.2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
