% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDistribution_Dirichlet.R
\name{Dirichlet}
\alias{Dirichlet}
\title{Dirichlet Distribution Class}
\value{
Returns an R6 object inheriting from class SDistribution.
}
\description{
Mathematical and statistical functions for the Dirichlet distribution, which
is commonly used as a prior in Bayesian modelling and is multivariate generalisation of the Beta distribution.
}
\details{
The Dirichlet distribution parameterised with  concentration parameters, \eqn{\alpha_1,...,\alpha_k}, is defined by the pdf, \deqn{f(x_1,...,x_k) = (\prod \Gamma(\alpha_i))/(\Gamma(\sum \alpha_i))\prod(x_i^{\alpha_i - 1})} for \eqn{\alpha = \alpha_1,...,\alpha_k; \alpha > 0}, where \eqn{\Gamma} is the gamma function.

The distribution is supported on \eqn{x_i \ \epsilon \ (0,1), \sum x_i = 1}{x_i \epsilon (0,1), \sum x_i = 1}.

\code{mgf} and \code{cf}
are
omitted as no closed form analytic expression could be found, decorate with \code{\link{CoreStatistics}} for numerical results.
\code{cdf} and \code{quantile}
are
omitted as no closed form analytic expression could be found, decorate with \code{\link{FunctionImputation}} for a numerical imputation.


Sampling is performed via sampling independent Gamma distributions and normalising the samples (Devroye, 1986).
}
\section{Constructor}{
 Dirichlet$new(params = c(1, 1), decorators = NULL, verbose = FALSE)
}

\section{Constructor Arguments}{

\tabular{lll}{
  \strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
  \code{params} \tab numeric \tab vector of concentration parameters. \cr
  
  
  
  
  
  
  
  
  
  \code{decorators} \tab Decorator \tab decorators to add functionality. See details. \cr
  \code{verbose} \tab logical \tab if TRUE parameterisation messages produced.
  }
}

\section{Constructor Details}{
 The Dirichlet distribution is parameterised with \code{params} as a vector of positive numerics. The parameter \code{K} is automatically calculated by counting the length of the params vector, once constructed this cannot be changed.
}

\section{Public Variables}{

 \tabular{ll}{
  \strong{Variable} \tab \strong{Return} \cr
  \code{name} \tab Name of distribution. \cr
  \code{short_name} \tab Id of distribution. \cr
  \code{description} \tab Brief description of distribution. \cr
  \code{package} \tab The package d/p/q/r are implemented in.
 }
}

\section{Public Methods}{

 \tabular{ll}{
  \strong{Accessor Methods} \tab \strong{Link} \cr
  \code{decorators()} \tab \code{\link{decorators}} \cr
  \code{traits()} \tab \code{\link{traits}} \cr
  \code{valueSupport()} \tab \code{\link{valueSupport}} \cr
  \code{variateForm()} \tab \code{\link{variateForm}} \cr
  \code{type()} \tab \code{\link{type}} \cr
  \code{properties()} \tab \code{\link{properties}} \cr
  \code{support()} \tab \code{\link{support}} \cr
  \code{symmetry()} \tab \code{\link{symmetry}} \cr
  \code{sup()}  \tab \code{\link{sup}} \cr
  \code{inf()} \tab \code{\link{inf}} \cr
  \code{dmax()}  \tab \code{\link{dmax}} \cr
  \code{dmin()} \tab \code{\link{dmin}} \cr
  \code{skewnessType()} \tab \code{\link{skewnessType}} \cr
  \code{kurtosisType()} \tab \code{\link{kurtosisType}} \cr

  \tab \cr \tab \cr \tab \cr

  \strong{Statistical Methods} \tab \strong{Link} \cr
  \code{pdf(x1, ..., log = FALSE, simplify = TRUE)} \tab \code{\link{pdf}} \cr
  \code{cdf(x1, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{cdf}}\cr
  \code{quantile(p, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)} \tab \code{\link{quantile.Distribution}} \cr
  \code{rand(n, simplify = TRUE)} \tab \code{\link{rand}} \cr
  \code{mean()} \tab \code{\link{mean.Distribution}} \cr
  \code{variance()} \tab \code{\link{variance}} \cr
  \code{stdev()} \tab \code{\link{stdev}} \cr
  \code{prec()} \tab \code{\link{prec}} \cr
  \code{cor()} \tab \code{\link{cor}} \cr
  \code{skewness()} \tab \code{\link{skewness}} \cr
  \code{kurtosis(excess = TRUE)} \tab \code{\link{kurtosis}} \cr
  \code{entropy(base = 2)} \tab \code{\link{entropy}} \cr
  \code{mgf(t)} \tab \code{\link{mgf}} \cr
  \code{cf(t)} \tab \code{\link{cf}} \cr
  \code{pgf(z)} \tab \code{\link{pgf}} \cr
  \code{median()} \tab \code{\link{median.Distribution}} \cr
  \code{iqr()} \tab \code{\link{iqr}} \cr

  \tab \cr \tab \cr \tab \cr

  \strong{Parameter Methods} \tab \strong{Link} \cr
  \code{parameters(id)} \tab \code{\link{parameters}} \cr
  \code{getParameterValue(id, error = "warn")}  \tab \code{\link{getParameterValue}} \cr
  \code{setParameterValue(..., lst = NULL, error = "warn")} \tab \code{\link{setParameterValue}} \cr

  \tab \cr \tab \cr \tab \cr

  \strong{Validation Methods} \tab \strong{Link} \cr
  \code{liesInSupport(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInSupport}} \cr
  \code{liesInType(x, all = TRUE, bound = FALSE)} \tab \code{\link{liesInType}} \cr

  \tab \cr \tab \cr \tab \cr

  \strong{Representation Methods} \tab \strong{Link} \cr
  \code{strprint(n = 2)} \tab \code{\link{strprint}} \cr
  \code{print(n = 2)} \tab \code{\link[base]{print}} \cr
  \code{summary(full = T)} \tab \code{\link{summary.Distribution}} \cr
  }
}

\examples{
# Different parameterisations
x <- Dirichlet$new(params = c(2,5,6))

# Update parameters
x$setParameterValue(params = c(3, 2, 3))
# 'K' parameter is automatically calculated
x$parameters()
\dontrun{
# This errors as less than three parameters supplied
x$setParameterValue(params = c(1, 2))
}

# d/p/q/r
# Note the difference from R stats
x$pdf(0.1, 0.4, 0.5)
# This allows vectorisation:
x$pdf(c(0.3, 0.2), c(0.6, 0.9), c(0.9,0.1))
x$rand(4)

# Statistics
x$mean()
x$variance()

summary(x)

}
\references{
McLaughlin, M. P. (2001). A compendium of common probability distributions (pp. 2014-01).
Michael P. McLaughlin.

Devroye, Luc (1986). Non-Uniform Random Variate Generation. Springer-Verlag. ISBN 0-387-96305-7.
}
\seealso{
\code{\link{listDistributions}} for all available distributions. \code{\link{Beta}} for the Beta distribution. \code{\link{CoreStatistics}} for numerical results. \code{\link{FunctionImputation}} to numerically impute d/p/q/r.
}
