% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disto_methods.R
\name{`[[.disto`}
\alias{`[[.disto`}
\alias{[[.disto}
\title{Extract a single value from disto object}
\usage{
\method{[[}{disto}(x, i, j, k)
}
\arguments{
\item{x}{object of class 'disto'}

\item{i}{(integer vector) row index}

\item{j}{(integer vector) column index}

\item{k}{(integer vector) direct index}
}
\value{
(A real number)  Distance value
}
\description{
Extract a single value from disto object in matrix style
  extraction and via direct indexing. This does not support using names. This
  is faster than \code{link{extract}}. For dist backend see:
  \code{\link{dist_extract}}.
}
\examples{
temp <- stats::dist(iris[,1:4])
dio  <- disto(objectname = "temp")
dio

dio[[1, 2]]
dio[[2, 1]]
dio[[k = 3]]
}
