% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distdichogen.R
\name{distdichogen}
\alias{distdichogen}
\alias{distdichogen.default}
\alias{distdichogen.formula}
\title{normal, skew-normal or gamma distributed data}
\usage{
distdichogen(x, ...)

\method{distdichogen}{default}(x, y, cp = 0, tail = c("lower", "upper"),
  conf.level = 0.95, dist = c("normal", "sk_normal", "gamma"),
  bootci = FALSE, nrep = 2000, ...)

\method{distdichogen}{formula}(formula, data, exposed, ...)
}
\arguments{
\item{x}{A numeric vector of data values.}

\item{...}{Further arguments to be passed to or from methods.}

\item{y}{A numeric vector of data values.}

\item{cp}{A numeric value specifying the cut point under which the distributional proportions are computed.}

\item{tail}{A character string specifying the tail of the distribution in which the proportions are computed.
Must be either 'lower' (default) or 'upper'.}

\item{conf.level}{Confidence level of the interval.}

\item{dist}{A character string specifying the distribution of the data. Must be either 'normal' (default), 'sk_normal or 'gamma'.}

\item{bootci}{A logical variable indicating whether bootstrap bias-corrected confidence intervals are calculated
instead of distributional ones.}

\item{nrep}{A numeric value, specifies the number of bootstrap replications (nrep must be higher than the number of observations).}

\item{formula}{A formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and
rhs a factor with two levels giving the corresponding exposed and unexposed groups.}

\item{data}{An optional matrix or data frame containing the variables
in the formula. By default, the variables are taken from \code{environment(formula)}.}

\item{exposed}{A character string specifying the grouping value of the exposed group.}
}
\value{
A list with class 'distdicho' containing the following components:
\item{data.name}{The names of the data.}
\item{arguments}{A list with the specified arguments.}
\item{parameter}{The mean, standard error and number of observations for both groups.}
\item{prop}{The estimated proportions below / above the cut point for both groups.}
\item{dist.estimates}{The difference in proportions, risk ratio and odds ratio of the groups.}
\item{se}{The estimated standard error of the difference in proportions, the risk ratio and the odds ratio.}
\item{ci}{The confidence intervals of the difference in proportions, the risk ratio and the odds ratio.}
\item{method}{A character string indicating the used method.}
\item{ttest}{A list containing the results of a t-test.}
}
\description{
distdichogen first returns the results of a two-group unpaired t-test.
Followed by the distributional estimates and their standard errors (see Sauzet et al. 2014 and Peacock et al. 2012)
for a difference in proportions, risk ratio and odds ratio. It also provides the distributional confidence intervals for the statistics estimated.
distdicho_gen takes normal (dist = 'normal'), skew normal (dist = 'sk_normal') and gamma (dist = 'gamma') distributed data.
The data can either be given as two variables, which provide the outcome in each group or specified as a formula
of the form lhs ~ rhs where lhs is a numeric variable giving the data values and
rhs a factor with two levels giving the corresponding exposed and unexposed groups.
In all cases, it is assumed that there are only two groups.
}
\examples{
## Proportions of low birth weight babies among smoking and non-smoking mothers
## (data from Peacock et al. 1995). Returns distributional estimates, standard 
## errors and distributional confidence intervals for differences in proportions,
## RR and OR of babies having a birth weight under 2500g (low birth weight)
## for group smoker (mother smokes) over the odds of LBW in group non-smoker 
## (mother doesn't smoke)
# Formula interface
distdichogen(birthwt ~ smoke, cp = 2500, data = bwsmoke, exposed = 'smoker',
             dist = 'sk_normal')
# Data stored in two vectors
bw_smoker <- bwsmoke$birthwt[bwsmoke$smoke == 'smoker']
bw_nonsmoker <- bwsmoke$birthwt[bwsmoke$smoke == 'non-smoker']
distdichogen(x = bw_smoker, y = bw_nonsmoker, 
              cp = 2500, tail = 'lower', dist = 'sk_normal')


## Body Mass Index (BMI) and parity. Returns distributional estimates, standard
## errors and distributional confidence intervals for difference in proportions,
## RR and OR of obese mothers (BMI of >30kg/m^2) for group_par=1 (multiparity) 
## over the odds of obesity in group_par=0 (primiparity)
distdichogen(bmi ~ group_par, cp = 30, data = bmi, exposed = '1',
             tail = 'upper', dist = 'sk_normal')




}
\references{
Peacock J.L., Sauzet O., Ewings S.M., Kerry S.M. Dichotomising continuous data while retaining statistical power using a distributional approach.  Statist. Med; 2012; 26:3089-3103.
Sauzet, O., Peacock, J. L. Estimating dichotomised outcomes in two groups with unequal variances: a distributional approach.  Statist. Med; 2014 33 4547-4559 ;DOI: 10.1002/sim.6255.
Sauzet, O., Ofuya, M., Peacock, J. L. Dichotomisation using a distributional approach when the outcome is skewed BMC Medical Research Methodology 2015, 15:40; doi:10.1186/s12874-015-0028-8.
Peacock, J.L., Bland, J.M., Anderson, H.R.: Preterm delivery: effects of socioeconomic factors, psychological stress, smoking, alcohol, and caffeine. BMJ 311(7004), 531-535 (1995).
}
\seealso{
\code{\link[distdichoR]{distdicho}}, \code{\link[distdichoR]{distdichoi}}, \code{\link[distdichoR]{distdichoigen}}, \code{\link[distdichoR]{regdistdicho}}
}
