% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dip4}
\alias{dip4}
\title{Dissolution data of two different formulations}
\format{
A data frame with 24 observations and 2 variables:
\describe{
  \item{type}{Factor with levels \code{ref} (Reference) and \code{test}
    (Test)}
  \item{x.10}{Numeric of the \% release at the 10 minutes testing point}
  \item{x.20}{Numeric of the \% release at the 20 minutes testing point}
  \item{x.30}{Numeric of the \% release at the 30 minutes testing point}
}
}
\source{
See reference: Example data set underlying Figure 1. Data set
\sQuote{\code{ex_data_pharmind}} from package \sQuote{\code{T2EQ}}.
}
\usage{
data(dip4)
}
\description{
A data set containing the dissolution data of one reference batch and one
  test batch of \eqn{n = 12} items each, i.e. the dissolution profiles of
  the \% drug release observed at 10, 20 and 30 minutes.
}
\examples{
str(dip4)

if (requireNamespace("T2EQ")) {
library(T2EQ)

  data(ex_data_pharmind, envir = environment())
  str(ex_data_pharmind)
  rm(ex_data_pharmind)
}
}
\references{
Hoffelder, T. Highly variable dissolution profiles. Comparison of
\eqn{T^2}-test for equivalence and \eqn{f_2} based methods. \emph{Pharm Ind}.
2016; \strong{78}(4): 587-592.\cr
\url{https://www.ecv.de/suse_item.php?suseId=Z|pi|8430}
}
\keyword{datasets}
