% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.test.wrapper.R
\name{model.test.wrapper}
\alias{model.test.wrapper}
\title{Model test wrapper}
\usage{
model.test.wrapper(data, model, pool.variance = NULL, time.split = NULL,
  fixed.optima = FALSE, control.list = list(fnscale = -1), verbose = TRUE,
  sim = 1000, plot.sim = TRUE, col.sim, col.obs = "hotpink",
  lwd.obs = 2, show.p = FALSE, cex.p, legend = FALSE, ...)
}
\arguments{
\item{data}{A \code{dispRity} object used to test models of evolution through time.}

\item{model}{The model(s) of evolution to allow for changes in disparity-through-time using a homogenous or hetergenous model, either using a single input or a list containing different models (see list in \code{\link{model.test}}). If a vector with multiple modes is supplied then the model will test for shifts in modes at the time supplied by \code{time.split}.}

\item{pool.variance}{If \code{NULL} (default) the difference in variances will be calculated using \code{\link[stats]{bartlett.test}} of equal variances. If there is no significant difference among variances, then variance in samples will be pooled and the same variance will be used for all samples. A significance difference will not pool variances and the original variance will be used for model-testing. If argument \code{TRUE} or \code{FALSE} are used, Bartlett's test will be ignored and the analyses will use the user-set pooling of variances.}

\item{time.split}{The age of the change in mode (\code{numeric}). The age is measured in positive units as the time before the most recent sample, and multiple ages can be supplied in a vector. If no age is supplied for models then all possible time shifts are fit in the model, and the highest likelihood model is returned. Note this only applies to heterogenous models (See \bold{Details}).}

\item{fixed.optima}{A \code{logical} value, whether to use an estimated optimum value in OU models (\code{FALSE} - default), or whether to set the OU optimum to the ancestral value (\code{TRUE}).}

\item{control.list}{A \code{list} of fine-tune control inputs for the optim function.}

\item{verbose}{\code{logical}, whether to display the model results as computed (\code{TRUE} - default).}

\item{sim}{The number of separate simulations (default = 1000).}

\item{plot.sim}{Logical. If \code{TRUE} (default) the plots of the simulated and observed disparity are returned for all models.}

\item{col.sim}{Colour options used for the plotting of simulated values. See \code{\link{plot.dispRity}} for more details. If missing, the default colours \code{c("black", "lightgrey", "grey")} are used.}

\item{col.obs}{Colour of the observed data on the plot. Default colour is \code{"hotpink"}}

\item{lwd.obs}{Line width of the observed value.}

\item{show.p}{Logical, when \code{plot.sim = TRUE}, whether to display the p-value of rank envelope tests (\code{TRUE}) or not (\code{FALSE} - default).}

\item{cex.p}{A numerical value for the the font size of the displayed p-value (if \code{show.p = TRUE}). If missing, the value is set to 1.}

\item{legend}{Logical, when \code{plot.sim = TRUE}, whether to display the legend in the first panel (\code{TRUE}) or not (\code{FALSE} - default).}

\item{...}{Any additional arguments to be passed to \code{\link{plot.dispRity}} or \code{\link{summary.dispRity}}.}
}
\value{
A matrix with the relative fit, parameter values, and Rank Envelope test p values for each model, and a plot of simulated data from each model alongside observed data for each model if plot.sim is \code{TRUE}
}
\description{
A wrapper function for \code{\link{model.test}} to perform a model fitting analysis on disparity through time data.
}
\details{
This function gives the relative fit of \code{model.test} output using log-likelihood and AICc values, as well as the Rank Envelope Test significance to elucidate if empirical data is significantly different to simulated data modelled using the estimated model parameters from \code{\link{model.test.sim}}. This is equivalent to running \code{test <- model.test.sim(sim = 1000, model = model.test(data, model)); summary(test) ; plot(test) ; plot(data, add = TRUE)}.
}
\examples{

\dontrun{
## Mammal disparity through time
data(BeckLee_disparity)

## The models to be fit to disparity data
models <- list("BM", "OU", "multi.OU", "Trend")

## test all models, and assess the significance of simulated data
## against the empirical distribution for each
model.test.wrapper(data = BeckLee_disparity, model = models, fixed.optima = TRUE,
                   time.split = 66, show.p = TRUE)
}

}
\references{
Blomberg SP, Garland T Jr, & Ives AR. 2003. Testing for phylogenetic signal in comparative data: behavioral traits are more labile. Evolution.  \bold{57}, 717-745.

Hansen TF. 1997. Stabilizing selection and the comparative analysis of adaptation. Evolution. \bold{51}, 1341-1351.

Harmon LJ, \emph{et al}. 2010. Early bursts of body size and shape evolution are rare in comparative data. \bold{64}, 2385-2396.

Hunt G. 2006. Fitting and comparing models of phyletic evolution: random walks and beyond. Paleobiology. \bold{32}, 578-601. DOI: 10.1666/05070.1.

Hunt G, Hopkins MJ & Lidgard S. 2015. Simple versus complex models of trait evolution and stasis as a response to environmental change. Proceedings of the National Academy of Sciences. \bold{112}, 4885-4890. DOI: 10.1073/pnas.1403662111

Felsenstein J. 1973. Maximum-likelihood estimation of evolutionary trees from continuous characters. American Journal of Human Genetics. \bold{25}, 471-492.

Felsenstein J. 1985. Phylogenies and the comparative method. The American Naturalist. \bold{51}, 1-15.

Murrell DJ. 2018. A global envelope test to detect non-random bursts of trait evolution. Methods in Ecology and Evolution. DOI: 10.1111/2041-210X.13006
}
\seealso{
\code{\link{model.test}}, \code{\link{model.test.sim}}, \code{\link{summary.dispRity}} and \code{\link{plot.dispRity}}
}
\author{
Mark N Puttick and Thomas Guillerme
}
