% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroupsNetAnalysis.R
\name{subgroupsNetAnalysis}
\alias{subgroupsNetAnalysis}
\title{Runs subgroup analysis on graphs}
\usage{
subgroupsNetAnalysis(ginp, raw_input = NULL, normalized = FALSE)
}
\arguments{
\item{ginp}{The prepared graph object from prepareGraphs function}

\item{raw_input}{The data of the original .csv file}

\item{normalized}{Normalize the betweeness centrality values}
}
\value{
Saves number of potential cliques, cores, symmetry of the graph, dyads in graphs, node composition in proposed cliques, neighbors adjacent to each node, transitivity (local and global) as a list object
}
\description{
Performs a subgroup analysis on the graph
}
\examples{
df <- sampleData1
prepNet <- tabulate_edges(df, iscsvfile = FALSE, silentNodes = 0)
baseNet <- prepareGraphs(prepNet, project_title = "Sample Data 1", weightedGraph = TRUE)
subgroupsNetAnalysis(baseNet, raw_input = df)

}
