% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixdiag.R
\name{msjd}
\alias{msjd}
\title{Mean Squared Jump Distance of a Markov Chain}
\usage{
msjd(X)
}
\arguments{
\item{X}{chain (Matrix) (in d dim)}
}
\value{
Mean squared jump distance of the chain.
}
\description{
We calculate mean square euclidean jumping distance. The target covariance is unknown and the assumption of elliptical contour might not hold here, hence, we dont implement the variance scaled version. And this version is computationally faster as well.
}
\details{
Mean squared jump distance of a markov chain is a measure used to diagnose the mixing of the chain. It is calculated as the mean of the squared eucledean distance between every point and its previous point. Usually, this quantity indicates if the chain is moving enough or getting stuck at some region.
}
\examples{
\dontrun{
## Banana Target
lupost.banana <- function(x,B){
 -x[1]^2/200 - 1/2*(x[2]+B*x[1]^2-100*B)^2
}
Banana Gradient
gr.banana <- function(x,B){
 g1 <- -x[1]/100 - 2*B*(x[2]+B*x[1]^2-100*B)
 g2 <- -(x[2]+B*x[1]^2-100*B)
 g <- c(g1,g2)
 return(g)
} 
out.metdir.banana <- metropdir(obj = lupost.banana, dobj = gr.banana,
initial = c(0,1),lchain = 2000,
sd.prop=1.25,
steplen=0.01,s=1.5,B=0.03)
msjd(out.metdir.banana$batch)
}
}
\author{
Abhirup Mallik, \email{malli066@umn.edu}
}
\seealso{
\code{\link{iact}} for integrated auto correlation times, \code{\link{mcmcdiag}}
for summary of diagnostic measures of a chain, \code{\link{multiESS}} for Multivariate effective sample size.
}
\keyword{dmh.}
\keyword{iact,}
\keyword{mcmc,}

