% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixdiag.R
\name{mcmcdiag}
\alias{mcmcdiag}
\title{mcmcdiag}
\usage{
mcmcdiag(X)
}
\arguments{
\item{X}{Chain (Matrix)}
}
\value{
list with following elements:
\itemize{
\item MEss Multivariate Effective sample size.
\item ess vector of effective sample size for each component.
\item iact vector of integrated autocorrelation times for each component.
\item msjd Mean squared jump distance for the chain.
}
}
\description{
This function calculates all different diagnostics supported in this library and returns in a list
}
\details{
This function calculates four metrics useful for diagnostics of a Markov chain. The chain input could be univariate or multivariate. The univariate summaries are calculated marginally, for each component for a multivariate chains. Effective sample size is calculated for each component. Integrared auto correlation times is also another componentwise measure calculated for all the components. Multivariate Effective sample size is calculated from mcmcse package. Mean squared jump distance is another multivariate summary measure that is returned.
}
\examples{
\dontrun{
## Banana Target
lupost.banana <- function(x,B){
 -x[1]^2/200 - 1/2*(x[2]+B*x[1]^2-100*B)^2
}
Banana Gradient
gr.banana <- function(x,B){
 g1 <- -x[1]/100 - 2*B*(x[2]+B*x[1]^2-100*B)
 g2 <- -(x[2]+B*x[1]^2-100*B)
 g <- c(g1,g2)
 return(g)
} 
out.metdir.banana <- metropdir(obj = lupost.banana, dobj = gr.banana,
initial = c(0,1),lchain = 2000,
sd.prop=1.25,
steplen=0.01,s=1.5,B=0.03)
mcmcdiag(out.metdir.banana$batch)
}
}
\author{
Abhirup Mallik, \email{malli066@umn.edu}
}
\seealso{
\code{\link{iact}} for integrated auto correlation times, \code{\link{msjd}}
for mean squared jump distance of a chain, \code{\link{multiESS}} for Multivariate effective sample size.
}
\keyword{dmh.}
\keyword{iact,}
\keyword{mcmc,}

