% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\name{dataSets}
\alias{dataSetList}
\alias{dataSets}
\alias{loadDataSet}
\title{Example Data Sets for dimensionality reduction}
\usage{
loadDataSet(name = dataSetList(), n = 2000, sigma = 0.05)

dataSetList()
}
\arguments{
\item{name}{A character vector that specifies the name of the data
set.}

\item{n}{In generated data sets the number of points to be
generated, else ignored.}

\item{sigma}{In generated data sets the standard deviation of the
noise added, else ignored.}
}
\value{
\code{loadDataSet} an object of class
    \code{\link{dimRedData}}. \code{dataSetList()} return a
    character string with the implemented data sets
}
\description{
A compilation of standard data sets that are often being used to
showcase dimensionality reduction techniques.
}
\details{
The argument \code{name} should be one of
\code{dataSetList()}. Partial matching is possible, see
\code{\link{match.arg}}. Generated data sets contain the internal
coordinates of the manifold in the \code{meta} slot.  Call
\code{dataSetList()} to see what data sets are available.
}
\examples{
## a list of available data sets:
dataSetList()

## Load a data set:
swissRoll <- loadDataSet("Swiss Roll")
\donttest{plot(swissRoll, type = "3vars")}

## Load Iris data set, partial matching:
loadDataSet("I")

}

