% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice_plot.R
\name{dice_plot}
\alias{dice_plot}
\title{Dice Plot Visualization}
\usage{
dice_plot(
  data,
  cat_a,
  cat_b,
  cat_c,
  group,
  plot_path = NULL,
  output_str = NULL,
  group_alpha = 0.5,
  title = NULL,
  cat_c_colors = NULL,
  group_colors = NULL,
  format = ".pdf",
  custom_theme = theme_minimal()
)
}
\arguments{
\item{data}{A data frame containing the categorical and group variables for plotting.}

\item{cat_a}{A string representing the column name in \code{data} for the first categorical variable.}

\item{cat_b}{A string representing the column name in \code{data} for the second categorical variable.}

\item{cat_c}{A string representing the column name in \code{data} for the third categorical variable.}

\item{group}{A string representing the column name in \code{data} for the grouping variable.}

\item{plot_path}{A string specifying the file path where the plot will be saved. Defaults to \code{NULL} (no file output).}

\item{output_str}{An optional string to customize the filename if \code{plot_path} is specified. Defaults to \code{NULL}.}

\item{group_alpha}{A numeric value for the transparency level of the group rectangles. Default is \code{0.5}.}

\item{title}{An optional string for the plot title. Defaults to \code{NULL}.}

\item{cat_c_colors}{A named vector of colors for \code{cat_c} categories. Defaults to \code{NULL} (automatically generated).}

\item{group_colors}{A named vector of colors for the group variable. Defaults to \code{NULL} (automatically generated).}

\item{format}{A string specifying the output file format if saving the plot. Defaults to \code{".pdf"}.}

\item{custom_theme}{A ggplot2 theme for customizing the plot's appearance. Defaults to \code{theme_minimal()}.}
}
\value{
A ggplot object representing the dice plot.
}
\description{
This function generates a custom plot based on three categorical variables and a group variable. It adapts to the number of unique categories in \code{cat_c} and allows customization of various plot aesthetics.
}
