% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.diagmeta.R
\name{plot.diagmeta}
\alias{plot.diagmeta}
\title{Plot for meta-analysis of diagnostic test accuracy studies with the
multiple cutoffs model}
\usage{
\method{plot}{diagmeta}(x, which = c("survival", "youden", "roc",
  "sroc"), xlab = "threshold", main, ci = FALSE, ciSens = FALSE,
  ciSpec = FALSE, mark.optcut = FALSE, mark.cutpoints = FALSE,
  points = TRUE, lines = FALSE, rlines = TRUE, line.optcut = TRUE,
  col.points = "rainbow", cex = 1, pch.points = 16,
  col.ci = "gray", cex.marks = 0.7 * cex, lwd = 1, lwd.optcut = 2 *
  lwd, shading = "none", ellipse = FALSE, xlim = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{diagmeta}}

\item{which}{A character vector indicating the type of plot, either
\code{"reg"} or\code{"cdf"} or \code{"survival"} or
\code{"Youden"} or \code{"ROC"} or \code{"SROC"} or
\code{"density"}}

\item{xlab}{An x axis label}

\item{main}{A logical indicating title to the plot}

\item{ci}{A logical indicating whether confidence intervals should
be plotted for \code{"reg"}, \code{"cdf"}, \code{"survival"},
\code{"Youden"}, and \code{"sensspec"}}

\item{ciSens}{A logical indicating whether confidence intervals
should be plotted for sensitivity, given the specificity in
\code{"SROC"} plot}

\item{ciSpec}{A logical indicating whether confidence intervals
should be plotted for specificity, given the sensitivity in
\code{"SROC"} plot}

\item{mark.optcut}{A logical indicating whether the optimal cutoff
should be marked on \code{"SROC"} plot}

\item{mark.cutpoints}{A logical indicating whether the given
cutoffs should be marked on \code{"SROC"} plot}

\item{points}{A logical indicating whether points should be plotted
on \code{"ROC"} plot}

\item{lines}{A logical indicating whether polygonal lines
connecting points belonging to the same study should be printed
in plots \code{"reg"}, \code{"cdf"}, \code{"survival"},
\code{"Youden"}, and \code{"sensspec"}}

\item{rlines}{A logical indicating whether regression lines or
curves should be plotted for plots \code{"reg"}, \code{"cdf"},
\code{"survival"}, \code{"Youden"}, and \code{"sensspec"}}

\item{line.optcut}{A logical indicating whether a vertical line
should be plotted at the optimal cutoff line for plots
\code{"cdf"}, \code{"survival"}, \code{"Youden"}, and
\code{"density"}}

\item{col.points}{A character string indicating color of points,
either \code{"rainbow"}, \code{"topo"}, \code{"heat"},
\code{"terrain"}, \code{"cm"}, \code{"grayscale"} or any color
defined in \code{\link[grDevices]{colours}}}

\item{cex}{A numeric indicating magnification to be used for
plotting text and symbols}

\item{pch.points}{A numeric indicating plot symbol(s) for points}

\item{col.ci}{A character string indicating color of confidence
lines}

\item{cex.marks}{A numeric indicating magnification(s) to be used
for marking cutoffs}

\item{lwd}{A numeric indicating line width}

\item{lwd.optcut}{A numeric indicating line width of optimal cutoff}

\item{shading}{A character indicating shading and hatching
confidence region in \code{"SROC"} plot, either \code{"none"} or
\code{"shade"} or \code{"hatch"}}

\item{ellipse}{A logical indicating whether a confidence ellipse
should be drawn around the optimal cutoff}

\item{xlim}{A character or numerical vector indicating the minimum
and maximum value for the horizontal axes}

\item{\dots}{Additional graphical arguments}
}
\description{
Provides several plots for meta-analysis of diagnostic test
accuracy studies with the multiple cutoffs model
}
\details{
The first argument of the plot function is an object of class
"diagmeta".

The second argument \code{which} indicates which sort of plot(s)
should be shown. For \code{which="reg"}, a scatter plot of the
quantil-transformed proportions of negative test results with two
regression lines is shown.  Points belonging to the same study are
marked with the same colour. For \code{which="cdf"}, the two
cumulative distribution functions are shown, corresponding to the
proportions of negative test results. For \code{which="survival"},
the survival functions are shown, corresponding to the proportions
of positive test results. For \code{which="Youden"}, the
(potentially weighted) sum of sensitivity and specificity minus 1
is shown; in case of \code{lambda=0.5} (the default) this is the
Youden index. For \code{which="ROC"}, study-specific ROC curves are
shown. For \code{which="SROC"}, the model-based summary ROC curve
is shown. For \code{which="density"}, the model-based densities of
both groups are shown. For \code{which="sensspec"}, the sensitivity
(decreasing with increasing cutoff) and the specificity (increasing
with increasing cutoff) are shown. Instead of character strings, a
numeric value or vector can be used to specify plots with numbers
corresponding to the following order of plots: "regression", "cdf",
"survival", "youden", "roc", "sroc", "density", and "sensspec".

Other arguments refer to further plot parameters, such as
\code{lines} (whether points belonging to the same study should be
joined), \code{rlines} (whether regression curves should be drawn),
\code{ci} / \code{ciSens} / \code{ciSpec} / \code{ellipse} (whether
confidence regions should be shown), \code{line.optcut} /
\code{mark.optcut} (whether the optimal cutoff should be
indicated), and additional plot parameters (see Arguments).

If no further arguments are provided, four standard plots
("survival", "Youden", "ROC", and "SROC") are produced in a 2 x 2
format.
}
\examples{
# FENO dataset
#
data(Schneider2017)

diag1 <- diagmeta(tpos, fpos, tneg, fneg, cutpoint,
                  studlab = paste(author, year, group),
                  data = Schneider2017,
                  model = "DIDS", log.cutoff = TRUE)


# Regression plot with confidence intervals
#
plot(diag1, which = "reg", lines = FALSE, ci = TRUE)

# Cumulative distribution plot with optimal cutoff line and
# confidence intervals
#
plot(diag1, which = "cdf", line.optcut = TRUE, ci = TRUE)

# Survival plot with optimal cutoff line and confidence intervals
#
plot(diag1, which = "survival", line.optcut = TRUE, ci = TRUE)

# Youden plot of optimal cutoff line and confidence intervals
#
plot(diag1, which = "youden",
     lines = TRUE, line.optcut = TRUE, ci = TRUE)

# ROC plot of lines connecting points belonging to the same study
#
plot(diag1, which = "ROC", lines = TRUE)

# SROC plot of confidence regions for sensitivity and specificity
# with optimal cutoff mark
#
plot(diag1, which = "SROC",
     ciSens = TRUE, ciSpec = TRUE, mark.optcut = TRUE,
     shading = "hatch")

# Density plot of densities for both groups with optimal cutoff
# line
#
plot(diag1, which = "density", line.optcut = TRUE)

}
\references{
Schneider A, Linde K, Reitsma JB, Steinhauser S, Rücker G (2017):
A novel statistical model for analyzing data of a systematic review
generates optimal cutoff values for fractional exhaled nitric oxide
for asthma diagnosis.
\emph{Journal of Clinical Epidemiology},
\bold{92}, 69--78

Steinhauser S, Schumacher M, Rücker G (2016):
Modelling multiple thresholds in meta-analysis of diagnostic test
accuracy studies.
\emph{BMC Medical Research Methodology},
\bold{16}, 97
}
\seealso{
\code{\link{diagmeta}}
}
\author{
Gerta Rücker \email{ruecker@imbi.uni-freiburg.de},
Susanne Steinhauser \email{susanne.steinhauser@uni-koeln.de},
Srinath Kolampally \email{kolampal@imbi.uni-freiburg.de},
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{hplot}
