% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.dfrr.R
\name{residuals.dfrr}
\alias{residuals.dfrr}
\title{Obtain residuals for a dfrr model}
\usage{
\method{residuals}{dfrr}(object, standardized = NULL, unstandardized = !standardized, ...)
}
\arguments{
\item{object}{a fitted \code{dfrr}-object obtained from invoking the function \code{\link{dfrr}}.}

\item{standardized, unstandardized}{a \code{boolean} indicating whether stanadrdized/unstandardized residuals are reported.
Defaults to \code{standardized=TRUE}.}

\item{...}{dot argument, just for consistency with the generic function}
}
\value{
This function returns either a \code{matrix} or  a \code{data.frame}.
If the argument ydata is specified, the return value is 'ydata' with
a column added, namely 'residual'. Otherwise, the return value
is a matrix of residuals of dimension NxM where N is the number of sample curves,
and  M is the length of argument 'yind' passed to the function \code{dfrr}.
}
\description{
Returns the residuals of a fitted \code{dfrr} model.
A \code{dfrr} model is of the form:
\deqn{Y_{i}(t)=I(W_{i}(t)>0),}
in which   \eqn{I(.)} is the indicator function and \eqn{W_{i}(t)=Z_{i}(t)+\epsilon_{i}(t)\times\sigma^2}, where \eqn{Z_{i}(t)} is the functional part of the model and \eqn{epsilon_{i}(t)\times\sigma^2} is the measurement error.
The functional part of the model, consisting a location and a residual function of the form:
\deqn{Z_{i}(t)=\sum_{j=1}^{q}\beta_{j}(t)*x_{ji}+\varepsilon_{i}(t),}
and \eqn{\epsilon_{i}(t)} are iid standard normal for each \eqn{i} and \eqn{t}.
The residuals reported in the output of this functions is the estimation of the
 measurement error of the model i.e. \eqn{\epsilon_{i}(t)\times\sigma^2}, which is estimated by:
 \deqn{E(W_{i}(t)-Z_{i}(t)\mid Y_{i}(t)).}
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24}
\dontshow{N<-30;M<-12}
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)

#The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)
resid<-residuals(dfrr_fit)


\donttest{plot(resid)}
# We can also use the qq function to draw the QQ-plot.

}
\seealso{
\code{\link{plot.residuals.dfrr}}, \code{\link{qq.dfrr}}
}
