% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{methods}
\name{plot,scen,missing-method}
\alias{plot,scen,missing-method}
\title{The graphical representation of the drug's concentration in the plasma at time t after the drug administration.}
\usage{
\S4method{plot}{scen,missing}(x, y = NA, col = rainbow(length(x@doses)),
  xlab = "Time (hours)", ylab = "Concentration (mg/L)",
  main = "Pharmacokinetics: Concentration vs Time", ...)
}
\arguments{
\item{x}{a "scen" object or a list of the selected trial from a "scen" object.}

\item{y}{the "y" argument is not used in the plot-method for "scen" object.}

\item{col}{the color argument to the \code{\link[=graphics]{plot.default}} function.}

\item{xlab}{the label of x-axis.}

\item{ylab}{the label of y-axis.}

\item{main}{the title of the graph.}

\item{\dots}{other arguments to the \code{\link[=graphics]{plot.default}} function can be passed here.}
}
\description{
The graphical representation of the drug's concentration in the plasma at time t after the drug administration.
}
\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal, <doi:10.1002/bimj.201600084>.

Toumazi, A., et al, (2018) dfpk: An R-package for Bayesian dose-finding designs using pharmacokinetics (PK) for phase I clinical trials, Computer Methods and Programs in Biomedicine, <doi:10.1016/j.cmpb.2018.01.023>.
}
\author{
Artemis Toumazi \email{artemis.toumazi@gmail.com}, Moreno Ursino \email{moreno.ursino@inserm.fr}, Sarah Zohar \email{sarah.zohar@inserm.fr}
}
