% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greeks.R
\name{greeks}
\alias{greeks}
\alias{bsopt}
\alias{greeks2}
\title{Calculate option Greeks}
\usage{
greeks(f, complete=FALSE, long=FALSE, initcaps=TRUE)
# must used named list entries:
greeks2(fn, ...)
bsopt(s, k, v, r, tt, d)
}
\arguments{
\item{s}{Price of underlying asset}

\item{k}{Option strike price}

\item{v}{Volatility of the underlying asset, defined as the
annualized standard deviation of the continuously-compounded
return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield of the underlying asset, annualized,
continuously-compounded}

\item{fn}{Pricing function name, not in quotes}

\item{f}{Fully-specified option pricing function, including inputs
which need not be named. For example, you can enter
\code{greeks(bscall(40, 40, .3, .08, .25, 0))}}

\item{complete}{FALSE. If TRUE, return a data frame with columns
equal to input parameters, function name, premium, and greeks
(each greek is a column). This is experimental and the output
may change. Convert to long format using \code{long=TRUE}.}

\item{long}{FALSE. If \code{complete=TRUE}, then \code{long=TRUE} will
return a long data frame, where each row contains input
parameters, function name, and either the premium or one of the
greeks}

\item{initcaps}{TRUE. If true, capitalize names (e.g. "Delta" vs
"delta")}

\item{...}{Pricing function inputs, must be named, may either be a
list or not}
}
\value{
A named list of Black-Scholes option prices and Greeks, or
    optionally (`complete=TRUE`) a dataframe.
}
\description{
The functions \code{greeks} and \code{greeks2} provide
two different calling conventions for computing a full set of
option Greeks. \code{greeks} simply requires entering a pricing function
with parameters. \code{greeks2} requires the use of named parameter
entries. The function \code{bsopt} calls \code{greeks2} to
produce a full set of prices and greeks for calls and puts. These
functions are all vectorized, the only restriction being that the
functions will produce an error if the recycling rule can not be
used safely (that is, if parameter vector lengths are not integer
multiples of one another).
}
\details{
Numerical derivatives are calculated using a simple
    difference. This can create numerical problems in edge
    cases. It might be good to use the package numDeriv or some
    other more sophisticated calculation, but the current approach
    works well with vectorization.
}
\note{
The pricing function being passed to the greeks function must
    return a numeric vector. For example, \code{callperpetual} must
    be called with the option \code{showbarrier=FALSE} (the
    default). The pricing function call cannot contain a variable
    named `z91k25`.
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0;
greeks(bscall(s, k, v, r, tt, d), complete=FALSE, long=FALSE, initcaps=TRUE)
greeks2(bscall, list(s=s, k=k, v=v, r=r, tt=tt, d=d))
greeks2(bscall, list(s=s, k=k, v=v, r=r, tt=tt, d=d))[c('Delta', 'Gamma'), ]
bsopt(s, k, v, r, tt, d)
bsopt(s, c(35, 40, 45), v, r, tt, d)
bsopt(s, c(35, 40, 45), v, r, tt, d)[['Call']][c('Delta', 'Gamma'), ]

## plot Greeks for calls and puts for 500 different stock prices
##
## This plot can generate a "figure margins too large" error
## in Rstudio
k <- 100; v <- 0.30; r <- 0.08; tt <- 2; d <- 0
S <- seq(.5, 250, by=.5)
Call <- greeks(bscall(S, k, v, r, tt, d))
Put <- greeks(bsput(S, k, v, r, tt, d))
y <- list(Call=Call, Put=Put)
par(mfrow=c(4, 4), mar=c(2, 2, 2, 2))  ## create a 4x4 plot
for (i in names(y)) {
    for (j in rownames(y[[i]])) {  ## loop over greeks
        plot(S, y[[i]][j, ], main=paste(i, j), ylab=j, type='l')
    }
}
\dontrun{
## Using complete option for calls
call_long <- greeks(bscall(S, k, v, r, tt, d), complete=TRUE, long=TRUE)
ggplot2::ggplot(call_long, aes(x=s, y=value)) +
      geom_line() + facet_wrap(~greek, scales='free')
}
}
