% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implied.R
\docType{data}
\name{implied}
\alias{.tol}
\alias{bscallimps}
\alias{bscallimpvol}
\alias{bsputimps}
\alias{bsputimpvol}
\alias{implied}
\title{Black-Scholes implied volatility and price}
\format{An object of class \code{numeric} of length 1.}
\usage{
bscallimpvol(s, k, r, tt, d, price)
bsputimpvol(s, k, r, tt, d, price)
bscallimps(s, k, v, r, tt, d, price)
bsputimps(s, k, v, r, tt, d, price)
}
\arguments{
\item{s}{Stock price}

\item{k}{Strike price of the option}

\item{v}{Volatility of the stock, defined as the annualized
standard deviation of the continuously-compounded return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{price}{Option price when computing an implied value}
}
\value{
Implied volatility (for the "impvol" functions) or implied
stock price (for the "impS") functions.
}
\description{
\code{bscallimpvol} and \code{bsputimpvol} compute
Black-Scholes implied volatilties. The functions \code{bscallimps}
and \code{bsputimps}, compute stock prices implied by a given
option price, volatility and option characteristics.
}
\details{
Returns a scalar or vector of option prices, depending on
the inputs
}
\note{
Implied volatilties and stock prices do not exist if the
price of the option exceeds no-arbitrage bounds. For example, if
the interest rate is non-negative, a 40 strike put cannot have a
price exceeding $40.
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0;
bscallimpvol(s, k, r, tt, d, 4)
bsputimpvol(s, k, r, tt, d, 4)
bscallimps(s, k, v, r, tt, d, 4)
bsputimps(s, k, v, r, tt, d, 4)

}
\keyword{datasets}

