% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom.R
\name{binom}
\alias{binom}
\alias{binomial}
\alias{binomopt}
\alias{binomplot}
\title{Binomial option pricing}
\usage{
binomopt(s, k, v, r, tt, d, nstep = 10, american = TRUE,
    putopt=FALSE, specifyupdn=FALSE, crr=FALSE, jarrowrudd=FALSE,
    up=1.5, dn=0.5, returntrees=FALSE, returnparams=FALSE,
    returngreeks=FALSE)

binomplot(s, k, v, r, tt, d, nstep, putopt=FALSE, american=TRUE,
    plotvalues=FALSE, plotarrows=FALSE, drawstrike=TRUE,
    pointsize=4, ylimval=c(0,0),
    saveplot = FALSE, saveplotfn='binomialplot.pdf',
    crr=FALSE, jarrowrudd=FALSE, titles=TRUE, specifyupdn=FALSE,
    up=1.5, dn=0.5, returnprice=FALSE, logy=FALSE)
}
\arguments{
\item{s}{Stock price}

\item{k}{Strike price of the option}

\item{v}{Volatility of the stock, defined as the annualized
standard deviation of the continuously-compounded return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{nstep}{Number of binomial steps. Default is \code{nstep = 10}}

\item{american}{Boolean indicating if option is American}

\item{putopt}{Boolean \code{TRUE} is the option is a put}

\item{specifyupdn}{Boolean, if \code{TRUE}, manual entry of the
binomial parameters up and down. This overrides the \code{crr}
and \code{jarrowrudd} flags}

\item{crr}{\code{TRUE} to use the Cox-Ross-Rubinstein tree}

\item{jarrowrudd}{\code{TRUE} to use the Jarrow-Rudd tree}

\item{up, dn}{If \code{specifyupdn=TRUE}, up and down moves on the
binomial tree}

\item{returntrees}{If \code{returntrees=TRUE}, the list returned by
the function includes four trees: for the price of the
underlying asset (stree), the option price (oppricetree), where
the option is exercised (exertree), and the probability of
being at each node. This parameter has no effect if
\code{returnparams=FALSE}, which is the default.}

\item{returnparams}{Return the vector of inputs and computed
pricing parameters as well as the price}

\item{returngreeks}{Return time 0 delta, gamma, and theta in the
vector \code{greeks}}

\item{plotvalues}{display asset prices at nodes}

\item{plotarrows}{draw arrows connecting pricing nodes}

\item{drawstrike}{draw horizontal line at the strike price}

\item{pointsize}{CEX parameter for nodes}

\item{ylimval}{\code{c(low, high)} for ylimit of the plot}

\item{saveplot}{boolean; save the plot to a pdf file named
\code{saveplotfn}}

\item{saveplotfn}{file name for saved plot}

\item{titles}{automatically supply appropriate main title and x-
and y-axis labels}

\item{returnprice}{if \code{TRUE}, the \code{binomplot} function
returns the option price}

\item{logy}{(FALSE). If \code{TRUE}, y-axis is plotted on a log
scale}
}
\value{
By default, \code{binomopt} returns the option price. If
    \code{returnparams=TRUE}, it returns a list where \code{$price}
    is the binomial option price and \code{$params} is a vector
    containing the inputs and binomial parameters used to compute
    the option price. Optionally, by specifying
    \code{returntrees=TRUE}, the list can include the complete
    asset price and option price trees, along with trees
    representing the replicating portfolio over time. The  current
    delta, gamma, and theta are also returned. If
    \code{returntrees=FALSE} and \code{returngreeks=TRUE}, only the
    current price, delta, gamma, and theta are returned. The function
    \code{binomplot} produces a visual representation of the
    binomial tree.
}
\description{
\code{binomopt} using the binomial pricing algorithm
    to compute prices of European and American calls and puts.
}
\details{
By default, \code{binomopt} returns an option
    price. Optionally, it returns a vector of the parameters used
    to compute the price, and if \code{returntrees=TRUE} it can
    also return the following matrices, all but but two of which
    have dimensionality \eqn{(\textrm{nstep}+1)\times
    (\textrm{nstep}+ 1)}{(nstep+1)*(nstep+1)}:

\describe{

\item{stree}{the binomial tree for the price of the underlying
    asset.}

\item{oppricetree}{the binomial tree for the option price at each
    node}

\item{exertree}{the tree of boolean indicators for whether or not
    the option is exercisd at each node}

\item{probtree}{the probability of reaching each node}

\item{delta}{at each node prior to expiration, the number of units
    of the underlying asset in the replicating portfolio. The
    dimensionality is \eqn{(\textrm{nstep})\times
    (\textrm{nstep})}{nstep*nstep}}

\item{bond}{at each node prior to expiration, the bond position in
    the replicating portfolio. The dimensionality is
    \eqn{(\textrm{nstep})\times (\textrm{nstep})}{nstep*nstep}}

}

\code{binomplot} plots the stock price lattice and shows
graphically the probability of being at each node (represented as
the area of the circle at that price) and whether or not the option
is optimally exercised there (green if yes, red if no), and
optionally, ht, depending on the inputs.
}
\note{
By default, \code{binomopt} computes the binomial tree using
    up and down moves of \deqn{u=\exp((r-d)*h + \sigma\sqrt{h})}{u
    = exp((r-d)*h + v*h^(0.5))} and \deqn{d=\exp((r-d)*h -
    \sigma\sqrt{h})}{d = exp((r-d)*h - v*h^(0.5))} You can use
    different trees: There is a boolean variable \code{CRR} to use
    the Cox-Ross-Rubinstein pricing tree, and you can also supply
    your own up and down moves with \code{specifyupdn=TRUE}. It's
    important to realize that if you do specify the up and down
    moves, you are overriding the volatility parameter.
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0; nstep=15

binomopt(s, k, v, r, tt, d, nstep, american=TRUE, putopt=TRUE)

binomopt(s, k, v, r, tt, d, nstep, american=TRUE, putopt=TRUE,
    returnparams=TRUE)

## matches Fig 10.8 in 3rd edition of Derivatives Markets
x <- binomopt(110, 100, .3, .05, 1, 0.035, 3, american=TRUE,
    returntrees=TRUE, returnparams=TRUE)
print(x$oppricretree)
print(x$delta)
print(x$bond)

binomplot(s, k, v, r, tt, d, nstep, american=TRUE, putopt=TRUE)

binomplot(s, k, v, r, tt, d, nstep, american=FALSE, putopt=TRUE)


}

