\name{mix.sim-class}

\docType{class}

\alias{mix.sim}
\alias{mix.sim-class}

\alias{nresp,mix.sim-method}
\alias{ntimes,mix.sim-method}
\alias{nstates,mix.sim-method}


\title{Class "mix.sim"}

\description{A \code{mix.sim} model. The \code{mix.sim} class directly
extends the \code{\link{mix}} class, and has an additional slot for the
true states. A \code{mix.sim} model can be generated by
\code{simulate(mod,...)}, where \code{mod} is a \code{\link{mix}} model.}

\section{Slots}{

	\describe{

	\item{\code{response}:}{List of list of \code{response} objects.}
	
	\item{\code{prior}:}{\code{\link{transInit}} object.}
	
	\item{\code{dens}:}{Array of dimension sum(ntimes)*nresp*nstates
		providing the densities of the observed responses for each state.}
	
	\item{\code{init}:}{Array of dimension \code{length(ntimes)}*nstates with 
		the current predictions for the initial state probabilities.}
	    
    \item{\code{ntimes}:}{A vector containing the lengths of independent time
		series; not applicable for mix objects, i.e. this is a vector of 1's.}
	
	\item{\code{nstates}:}{The number of states/classes of the model.}

	\item{\code{nresp}:}{The number of independent responses.}

	\item{\code{npars}:}{The total number of parameters of the model.  
		This is not the degrees of freedom, ie there are redundancies in the
		parameters, in particular in the multinomial models for the transitions
		and prior.}
		
  \item{\code{states}:}{A matrix with the true states/classes.}

	}
}

\section{Accessor Functions}{
	The following functions should be used for accessing the corresponding
	slots:
	\describe{
		\item{\code{npar}:}{The number of parameters of the model.}
		\item{\code{nresp}:}{The number of responses.}
		\item{\code{nstates}:}{The number of states.}
		\item{\code{ntimes}:}{The vector of independent time series lengths.}
	}
}

\author{Ingmar Visser}

\keyword{classes}
