% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{Chronometer}
\alias{Chronometer}
\title{Chronometer object}
\description{
R6 object that mimics a chronometer. It can be started, paused, record legs
and stopped.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Chronometer-show}{\code{Chronometer$show()}}
\item \href{#method-Chronometer-reset}{\code{Chronometer$reset()}}
\item \href{#method-Chronometer-start}{\code{Chronometer$start()}}
\item \href{#method-Chronometer-stop}{\code{Chronometer$stop()}}
\item \href{#method-Chronometer-record.leg}{\code{Chronometer$record.leg()}}
\item \href{#method-Chronometer-get.chronometer.data}{\code{Chronometer$get.chronometer.data()}}
\item \href{#method-Chronometer-get.total.time}{\code{Chronometer$get.total.time()}}
\item \href{#method-Chronometer-accumulate.legs}{\code{Chronometer$accumulate.legs()}}
\item \href{#method-Chronometer-clone}{\code{Chronometer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-show"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-show}{}}}
\subsection{Method \code{show()}}{
Display the values stored in this chronometer object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the chronometer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-start"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-start}{}}}
\subsection{Method \code{start()}}{
Start the chronometer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$start()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-stop}{}}}
\subsection{Method \code{stop()}}{
Stop the chronometer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$stop(leg.name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leg.name}}{(optional) Name for the stopped leg.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-record.leg"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-record.leg}{}}}
\subsection{Method \code{record.leg()}}{
Record a leg time. The chronometer will continue running.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$record.leg(leg.name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leg.name}}{Name for the recorded leg.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-get.chronometer.data"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-get.chronometer.data}{}}}
\subsection{Method \code{get.chronometer.data()}}{
Like \code{show} method, but more rudimentary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$get.chronometer.data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-get.total.time"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-get.total.time}{}}}
\subsection{Method \code{get.total.time()}}{
Return the total time span between start and stop.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$get.total.time(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{Boolean variable. If \code{TRUE}, avoids error when calling
this function while chronometer has not been stopped yet.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-accumulate.legs"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-accumulate.legs}{}}}
\subsection{Method \code{accumulate.legs()}}{
Return total time spent per leg category (using leg names).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$accumulate.legs(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{force Boolean variable. If \code{TRUE}, avoids error when calling
this function while chronometer has not been stopped yet.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chronometer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Chronometer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chronometer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
