% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycle_stats.R
\name{cycle_stats}
\alias{cycle_stats}
\title{Define stem cycles and calculate statistics for all cyclic phases}
\usage{
cycle_stats(dm.gpf, dm.phase, sensor = 1, smooth.param = 1)
}
\arguments{
\item{dm.gpf}{a \code{data.frame} with either gap-free or gap-filled dendrometer series as produced by \code{\link{fill_gaps}}.}

\item{dm.phase}{a \code{data.frame} with numbers indicating the different stem-cyclic phases. Output of \code{\link{phase_def}}.}

\item{sensor}{a \code{numeric} specifying the sensor to be used in the function. Defaults to 1 (first column in both \code{data.frames}).}

\item{smooth.param}{a \code{numeric} specifying the degree of smoothing. Defaults to 1 (no smoothing).}
}
\value{
The function returns a \code{list} with:
\itemize{\item{a \code{data.frame} named \code{cycleStats} containing the following summary statistics:}}
\item{dmID}{dendrometer ID.}
\item{cycle}{cycle number.}
\item{phase}{cyclic phase (1: contraction, 2: expansion, 3: stem-radius increment, 4: full cycle).}
\item{begin}{timestamp indicating the beginning of each phase.}
\item{end}{timestamp indicating the end of each phase.}
\item{duration_h}{phase duration in hours.}
\item{duration_m}{phase duration in minutes.}
\item{magnitude}{magnitude of stem-size changes in each phase.}
\item{min}{minimum stem size within each phase.}
\item{max}{maximum stem size within each phase.}

\itemize{\item{a \code{data.frame} named \code{cycle.df} containing, for all individual records, the following columns:}}
\item{dmID}{dendrometer ID.}
\item{cycle}{cycle number.}
\item{phase}{cyclic phase (1: contraction, 2: expansion, 3: stem-radius increment, 4: full cycle).}
}
\description{
The function defines stem cycles from output of \code{\link{phase_def}} and calculates statistics for complete cycles as well as for the phases of contraction, expansion and stem-radius increment.
}
\details{
The function uses the output of \code{\link{phase_def}} to define stem cycles and to calculate statistics for all cyclic phases. These statistics include the timing and duration of each phase, as well as information on stem-size changes. The function works for single dendrometer series, which are defined by the argument \code{sensor}.

The function includes a smoothing option (argument \code{smooth.param}) particularly for noisy datasets in which outliers may under- or overestimate the minimum and maximum stem size within phases and stem cycles. By default, no smoothing is performed.
}
\examples{
data(dmCD)
dm.phase <- phase_def(dmCD)
dm.stats <- cycle_stats(dmCD, dm.phase)

}
\author{
Olivier Bouriaud, Ernst van der Maaten and Marieke van der Maaten-Theunissen.
}

