% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdm.R
\name{plot.errorfdm}
\alias{plot.errorfdm}
\title{Plot differences between actuals and estimates from fitted demographic model}
\usage{
\method{plot}{errorfdm}(x, transform = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{"errorfdm"} generated by \code{\link{compare.demogdata}}.}

\item{transform}{Plot errors on transformed scale or original scale?}

\item{...}{Plotting parameters.}
}
\description{
Function produces a plot of errors from a fitted demographic model.
}
\examples{
fr.fit <- lca(extract.years(fr.mort,years=1921:1980))
fr.error <- compare.demogdata(fr.mort, forecast(fr.fit,20))
plot(fr.error)

}
\seealso{
\link{compare.demogdata}
}
\author{
Rob J Hyndman
}
\keyword{hplot}
