\name{plot.fmres}
\alias{plot.fmres}
\title{Plot residuals from fitted demographic model}
\usage{\method{plot}{fmres}(x, type = c("image", "fts", "contour", "persp"),
		xlab = "Year", ylab = "Age", zlab = "Error", ...)
}

\arguments{
\item{x}{Generated by \code{residuals(fit)} where \code{fit} is the output from
	\code{\link{fdm}} or \code{\link{lca}}.}
\item{type}{Type of plot to use. Possiblities are \dQuote{image}, \dQuote{fts}, \dQuote{contour} and \dQuote{persp}.}
\item{xlab}{Label for x-axis.}
\item{ylab}{Label for y-axis.}
\item{zlab}{Label for z-axis.}
\item{...}{Plotting parameters}
}

\description{Functions to produce a plot of residuals from a fitted demographic model or a
fitted functional time series model.}

\value{None.}

\seealso{\link{fdm}, \link{lca}, \link[ftsa]{ftsm}}

\author{Rob J Hyndman}
\examples{
france.fit <- fdm(fr.mort)
plot(residuals(france.fit))
}
\keyword{hplot}
