% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/DEMIDiff-methods.R, R/DEMIExperiment-methods.R
\docType{methods}
\name{getProbeLevel}
\alias{getProbeLevel}
\alias{getProbeLevel,DEMIDiff,vector,logical-method}
\alias{getProbeLevel,DEMIExperiment,vector,logical-method}
\title{Returns the probe levels from the normalized expression matrix for the specified probes}
\usage{
getProbeLevel(object, probes, verbose)

\S4method{getProbeLevel}{DEMIDiff,vector,logical}(object, probes, verbose)

\S4method{getProbeLevel}{DEMIExperiment,vector,logical}(object, probes,
  verbose = TRUE)
}
\arguments{
\item{object}{A \code{DEMIExperiment} or \code{DEMIDiff} object.}

\item{probes}{A \code{vector}. A vector of probe ID's whose expression levels should be returned.}

\item{verbose}{A \code{logical}. If TRUE it will print out the probe ID's that were not found in
normalized expression matrix.}
}
\value{
Returns the probe levels in the normalized expression matrix for the specified probes.
}
\description{
The function \code{getProbeLevel} returns the probe levels in the normalized expression matrix specified
by the probe ID's.
}
\details{
To see what are the available probes in the normalized expression matrix you can try \code{row.names(getNormMatrix(x))}
where x is an object of class \code{DEMIExperiment}.
}
\examples{
\dontrun{

# To use the example we need to download a subset of CEL files from
# http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE9819 published
# by Pradervand et al. 2008.

# Set the destination folder where the downloaded files fill be located.
# It can be any folder of your choosing.
destfolder <- "demitest/testdata/"

# Download packed CEL files and change the names according to the feature
# they represent (for example to include UHR or BRAIN in them to denote the
# features).
# It is good practice to name the files according to their features which
# allows easier identification of the files later.

ftpaddress <- "ftp://ftp.ncbi.nlm.nih.gov/geo/samples/GSM247nnn"
download.file( paste( ftpaddress, "GSM247694/suppl/GSM247694.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR01_GSM247694.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247695/suppl/GSM247695.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR02_GSM247695.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247698/suppl/GSM247698.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR03_GSM247698.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247699/suppl/GSM247699.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR04_GSM247699.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247696/suppl/GSM247696.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN01_GSM247696.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247697/suppl/GSM247697.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN02_GSM247697.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247700/suppl/GSM247700.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN03_GSM247700.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247701/suppl/GSM247701.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN04_GSM247701.CEL.gz", sep = "" ) )

# We need the gunzip function (located in the R.utils package) to unpack the gz files.
# Also we will remove the original unpacked files for we won't need them.
library( R.utils )
for( i in list.files( destfolder ) ) {
	gunzip( paste( destfolder, i, sep = "" ), remove = TRUE )
}

# Now we can continue the example of the function getProbeLevel

# Set up an experiment
demiexp <- DEMIExperiment( analysis = 'gene', celpath = destfolder,
			experiment = 'myexperiment', organism = 'homo_sapiens' )

# Create clusters with an optimized wilcoxon's rank sum test incorporated within demi that
# precalculates the probabilities
demiclust <- DEMIClust( demiexp, group = c( "BRAIN", "UHR" ), clust.method = demi.wilcox.test.fast )

# Calcuate differential expression
demidiff <- DEMIDiff( demiclust )

# Retrieve the probe levels specified by probe ID's of the normalized expression matrix
getProbeLevel( demiexp, c( 1171,1182 ), TRUE )
getProbeLevel( demidiff, c( 1171,1182 ), TRUE )

}
}
\author{
Sten Ilmjarv
}
\seealso{
\code{DEMIExperiment}, \code{DEMIDiff}
}

