% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{ImportSim}
\alias{ImportSim}
\title{Import an existing data frame for use with the package}
\usage{
ImportSim(dejaData, event.times, status, study.time, censored.time = NULL,
  actual.events = NULL, allow.beyond.study = FALSE)
}
\arguments{
\item{dejaData}{a \code{DejaData} object contain the subject
covariates and treatment arm}

\item{event.times}{A list of vectors, containing the observed
event times of each subject. If no events are observed then
numeric(0) should be used. See example in this help file for more
details}

\item{status}{The status of the data set imported, either
"complete" (if all subjects complete their follow up period) or
"dropout" (if not)}

\item{study.time}{The total follow up time according to study
protocol}

\item{censored.time}{If status is "dropout", this is a vector of
the times at which each subject is censored}

\item{actual.events}{If status is "dropout" and the total number
of events (i.e. not just the number observed) is known (e.g. if a
different simulation procedure was used) a vector of total number
of events should be included. If the number is not known or status
is "complete" then this should be set to NULL}

\item{allow.beyond.study}{Whether or not to allow imported data
with events after the nominal end of study.}
}
\value{
A SingleSim object
}
\description{
Import an existing data frame for use with the package
}
\examples{

covar.df <- data.frame(Id=1:6,
                       arm=c(rep(0,3),rep(1,3)),
                       Z=c(0,1,1,0,1,0))
 
dejaData <- MakeDejaData(covar.df,arm="arm",Id="Id") 


event.times <- list(c(25,100,121,200,225),
                    c(100,110),c(55),numeric(0),
                    150,45)     

complete.dataset <- ImportSim(dejaData, event.times,
                    status="complete",
                    study.time=365)
 
censored.time  <- c(365,178,100,245,200,100)

dropout.dataset <- ImportSim(dejaData, event.times,
                    status="dropout",
                    study.time=365,
                    censored.time=censored.time)

}
