/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.matching;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.util.ArrayUnenforcedSet;
import org.jgrapht.util.TypeUtil;

public class EdmondsBlossomShrinking<V, E>
implements MatchingAlgorithm<V, E> {
    private final UndirectedGraph<V, E> graph;
    private Map<V, V> match;
    private Map<V, V> path;
    private Map<V, V> contracted;

    public EdmondsBlossomShrinking(Graph<V, E> graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Input graph cannot be null");
        }
        if (!(graph instanceof UndirectedGraph)) {
            throw new IllegalArgumentException("Only undirected graphs supported");
        }
        this.graph = (UndirectedGraph)TypeUtil.uncheckedCast(graph, null);
    }

    @Override
    public MatchingAlgorithm.Matching<E> computeMatching() {
        Set<E> edges = this.findMatch();
        return new MatchingAlgorithm.MatchingImpl<E>(edges, edges.size());
    }

    private Set<E> findMatch() {
        ArrayUnenforcedSet result = new ArrayUnenforcedSet();
        this.match = new HashMap<V, V>();
        this.path = new HashMap<V, V>();
        this.contracted = new HashMap<V, V>();
        for (Object i : this.graph.vertexSet()) {
            if (this.match.containsKey(i)) continue;
            Object v2 = this.findPath(i);
            while (v2 != null) {
                V pv = this.path.get(v2);
                V ppv = this.match.get(pv);
                this.match.put(v2, pv);
                this.match.put(pv, v2);
                v2 = ppv;
            }
        }
        HashSet seen = new HashSet();
        this.graph.vertexSet().stream().filter(v -> !seen.contains(v) && this.match.containsKey(v)).forEach(v -> {
            seen.add(v);
            seen.add(this.match.get(v));
            result.add(this.graph.getEdge(v, this.match.get(v)));
        });
        return result;
    }

    private V findPath(V root) {
        HashSet used = new HashSet();
        ArrayDeque q = new ArrayDeque();
        this.path.clear();
        this.contracted.clear();
        this.graph.vertexSet().forEach(vertex -> this.contracted.put(vertex, vertex));
        used.add(root);
        q.add(root);
        while (!q.isEmpty()) {
            Object v = q.remove();
            for (Object e : this.graph.edgesOf(v)) {
                Object to = this.graph.getEdgeSource(e);
                if (to.equals(v)) {
                    to = this.graph.getEdgeTarget(e);
                }
                if (this.contracted.get(v).equals(this.contracted.get(to)) || to.equals(this.match.get(v))) continue;
                if (to.equals(root) || this.match.containsKey(to) && this.path.containsKey(this.match.get(to))) {
                    Object stem = this.lowestCommonAncestor(v, to);
                    HashSet blossom = new HashSet();
                    this.markPath(v, to, stem, blossom);
                    this.markPath(to, v, stem, blossom);
                    this.graph.vertexSet().stream().filter(i -> this.contracted.containsKey(i) && blossom.contains(this.contracted.get(i))).forEach(i -> {
                        this.contracted.put(i, stem);
                        if (!used.contains(i)) {
                            used.add(i);
                            q.add(i);
                        }
                    });
                    continue;
                }
                if (this.path.containsKey(to)) continue;
                this.path.put(to, v);
                if (!this.match.containsKey(to)) {
                    return to;
                }
                to = this.match.get(to);
                used.add(to);
                q.add(to);
            }
        }
        return null;
    }

    private void markPath(V v, V child, V stem, Set<V> blossom) {
        while (!this.contracted.get(v).equals(stem)) {
            blossom.add(this.contracted.get(v));
            blossom.add(this.contracted.get(this.match.get(v)));
            this.path.put(v, child);
            child = this.match.get(v);
            v = this.path.get(this.match.get(v));
        }
    }

    private V lowestCommonAncestor(V a, V b) {
        HashSet<V> seen = new HashSet<V>();
        while (true) {
            a = this.contracted.get(a);
            seen.add(a);
            if (!this.match.containsKey(a)) break;
            a = this.path.get(this.match.get(a));
        }
        while (!seen.contains(b = this.contracted.get(b))) {
            b = this.path.get(this.match.get(b));
        }
        return b;
    }
}

