% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp.R
\name{decomp}
\alias{decomp}
\title{Interface Function for Decompositions}
\usage{
decomp(
  iot,
  x,
  y,
  k,
  i,
  o = NULL,
  v = NULL,
  method = c("leontief", "kww", "wwz"),
  ...
)
}
\arguments{
\item{iot}{a Input Output Table object - a list with elements 'inter' (= x), 'final' (= y), 'output' (= o), 'countries' (= k) and 'industries' (= i) of class 'iot'. 
Alternatively these objects can be passed directly to the function, at least x, y, k and i need to be supplied.}

\item{x}{intermediate demand table supplied as a numeric matrix of dimensions GN x GN (G = no. of country, N = no. of industries). 
Both rows and columns should be arranged first by country, then by industry (e.g. C1I1, C1I2, ..., C2I1, C2I2, ...) and should match (symmetry), 
such that rows and columns refer to the same country-industries.}

\item{y}{final demand table supplied as a numeric matrix of dimensions GN x MN (M = no. of final demand categories recorded for each country). 
The rows of y need to match the rows of x, and the columns should also be arranged first by country, then by final demand category (e.g. C1FD1, C1FD2, ..., C2FD1, C2FD2, ...) with the order of the 
countries the same as in x.}

\item{k}{character. A vector of country or region names of length G, arranged in the same order as they occur in the rows and columns of x, y.}

\item{i}{character. A vector of country or region names of length N, arranged in the same order as they occur in the rows and columns of x and rows of y.}

\item{o}{numeric. A vector of final outputs for each country-industry matching the rows of x and y. If not provided it will be computed as \code{rowSums(x) + rowSums(y)}.}

\item{v}{numeric. A vector of value added for each country-industry matching the columns of x. If not provided it will be computed as \code{o - colSums(x)}.}

\item{method}{character. The decomposition method, either \code{"leontief"}, \code{"kww"} or \code{"wwz"}.}

\item{\dots}{further arguments passed to \code{\link{leontief}}, \code{\link{kww}} or \code{\link{wwz}}.}
}
\value{
Depends on the decomposition, see \code{\link{leontief}}, \code{\link{kww}} or \code{\link{wwz}}.
 % The output when using the WWZ algorithm is a matrix with dimensions GNG*19.
 % Whereby 19 is the 16 objects the WWZ algorithm decomposes exports into, plus three checksums.
 % GNG represents source country, using industry and using country.
}
\description{
This function loads an ICIO table and runs a specified decomposition. It provides a compact interface for quick analysis.
}
\details{
For more detailed analysis with multiple decompositions consider using 
\code{\link{load_tables_vectors}} to create a 'decompr' class object and then run the decomposition functions \code{\link{leontief}}, \code{\link{kww}} and \code{\link{wwz}} on the object.
}
\examples{
# Load leather example data
data(leather)

# Explore the data
str(leather)

## Decomposing gross exports:

# Perform the Leontief decomposition
decomp(leather, method = "leontief")

# Perform the KWW decomposition
decomp(leather, method = "kww")

# Perform the WWZ decomposition
decomp(leather, method = "wwz")

}
\references{
{Timmer, Marcel P. (ed) (2012), "The World Input-Output Database (WIOD): Contents Sources and Methods", \emph{WIOD Working Paper Number 10}, downloadable at http://www.wiod.org/publications/papers/wiod10.pdf }

{Wang, Zhi, Shang-Jin Wei, and Kunfu Zhu (2013). Quantifying international production sharing at the bilateral and sector levels. \emph{No. w19677. National Bureau of Economic Research}.}
}
\seealso{
\code{\link{decompr-package}}
}
\author{
Bastiaan Quast
}
