% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_grid-cell-layer.R
\name{add_grid_cell_layer}
\alias{add_grid_cell_layer}
\title{Add a grid cell layer to the deckgl widget}
\usage{
add_grid_cell_layer(deckgl, id = "grid-cell-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{id}{The unique id of the layer.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class.}

\item{...}{More properties that will be added to the \code{properties} object. This can be useful
if you want to use a properties object for more than one layer.}
}
\description{
The \code{GridCellLayer} can render a grid-based heatmap.
It is a variation of the \code{ColumnLayer}. It takes the constant width / height of all cells and top-left coordinate of each cell.
The grid cells can be given a height using the \code{getElevation} accessor.
}
\examples{
hexagon_centroids <- system.file("sample-data/centroids.csv", package = "deckgl") \%>\%
  read.csv()

deck <- deckgl(zoom = 11, pitch = 35) \%>\%
  add_grid_cell_layer(
    data = hexagon_centroids,
    getPosition = ~lng + lat,
    getElevation = ~value,
    getFillColor = JS("d => [48, 128, d.value * 255, 255]"),
    elevationScale = 5000,
    cellSize = 250,
    extruded = TRUE,
    getTooltip = JS("object => `height: ${object.value * 5000}m`")
  ) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/grid-cell-layer}
}
