\name{get_grid_mix}
\alias{get_grid_mix}
\title{Gets mix of fuel sources in UK electricity}
\source{
  The underlying data come from BM Reports,
  \url{http://www.bmreports.com/bsp/bsp_home.htm}, and are
  used under license from Elexon (see disclaimer below).
  However the BM Reports website is hard to use and so this
  function uses archived Elexon data compiled by the
  charity Renewable Energy Foundation and available at no
  cost at \url{http://www.ref.org.uk/fuel/}. ELEXON does
  not and shall not be deemed to warrant or guarantee or
  make any representation (whether expressly or impliedly)
  as to the title, completeness, accuracy, reliability,
  freeness from error, method of preparation,
  merchantability or fitness for the purpose or for any
  particular purpose (whether or not any such purpose has
  been notified to ELEXON) of the Licensed Data and/or any
  use of or dealing with it.  ELEXON shall have no
  liability or responsibility whatsoever or howsoever
  arising (whether directly or indirectly) as a result of
  or in connection therewith, including in respect of each
  and all loss of profits, loss of revenue, loss of
  goodwill, loss of contracts, loss of business or
  production, indirect loss, economic or consequential
  loss, claims, demands, proceedings, actions, losses,
  liabilities, damages, costs, charges and expenses
  (whether or not any of the foregoing are foreseeable)
}
\usage{
  get_grid_mix(start, end)
}
\arguments{
  \item{start}{the start date for retrieving data.}

  \item{end}{the end date for retrieving data}
}
\value{
  a data frame with a datetime stamp and average power
  generated by fuel type in MW
}
\description{
  Gets the mix of fuel sources used to generate UK grid
  electricity between specified dates.  Valid dates are
  yyyy-mm-dd and must be between 2009-01-01 and the current
  day; the start must come before the end date.
}
\examples{
# These require a working internet connection
start <- "2010-01-01"
end <- "2010-01-07"
if (url.exists("http://www.google.com")) {
  data <- get_grid_mix(start, end) # Gets data for 1st week of January 2010
}
}

