% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_DDT_functions.R
\name{simulate_DDT_tree}
\alias{simulate_DDT_tree}
\title{Simulate a tree from a DDT process. Only the tree topology and branch lengths
are simulated, without node parameters.}
\usage{
simulate_DDT_tree(K, c, c_order = 1, alpha = 0, theta = 0)
}
\arguments{
\item{K}{number of leaves (classes) on the tree}

\item{c}{hyparameter of divergence function a(t)}

\item{c_order}{equals 1 (default) or 2 to choose divergence function
a(t) = c/(1-t) or c/(1-t)^2.}

\item{alpha, theta}{hyparameter of branching probability a(t) Gamma(m-alpha) / Gamma(m+1+theta)
For DDT, alpha = theta = 0. For general multifurcating tree from a Pitman-Yor process,
specify positive values to alpha and theta. It is, however, recommended using alpha =
theta = 0 in inference because multifurcating trees have not been tested rigorously.}
}
\value{
A class "phylo" tree with K leaves. The leaf nodes are labeled "v1", ..., "vK",
root node "u1", and internal nodes "u2", ..., "uK". Note that this tree does not contain
any node parameters.
}
\description{
Simulate a tree from a DDT process. Only the tree topology and branch lengths
are simulated, without node parameters.
}
\examples{
K <- 6
c <- 5
c_order <- 1
tree1 <- simulate_DDT_tree(K, c, c_order)
tree2 <- simulate_DDT_tree(K, c, c_order, alpha = 0.4, theta = 0.1)
tree3 <- simulate_DDT_tree(K, c, c_order, alpha = 0.8, theta = 0.1)
}
\references{
{
Knowles, D. A., & Ghahramani, Z. (2014). Pitman yor diffusion trees for bayesian hierarchical
clustering. IEEE transactions on pattern analysis and machine intelligence, 37(2), 271-289.
}
}
\seealso{
Other simulate DDT-LCM data: 
\code{\link{simulate_lcm_given_tree}()},
\code{\link{simulate_lcm_response}()},
\code{\link{simulate_parameter_on_tree}()}
}
\concept{simulate DDT-LCM data}
