% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcSparseMatrix.r
\name{dcSparseMatrix}
\alias{dcSparseMatrix}
\title{Function to create a sparse matrix for an input file with three columns}
\usage{
dcSparseMatrix(input.file, verbose = T)
}
\arguments{
\item{input.file}{an input file containing three columns: 1st column
for rows, 2nd for columns, and 3rd for numeric values. Alternatively,
the input.file can be a matrix or data frame, assuming that input file
has been read. Note: the file should use the tab delimiter as the field
separator between columns}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
a list containing arguments and their default values
}
\description{
\code{dcSparseMatrix} is supposed to create a sparse matrix for an
input file with three columns.
}
\note{
This function is potentially useful when debugging. Because the
developer does not have to specify default values for all arguments
except those arguments are of interest
}
\examples{
# create a sparse matrix of 4 X 2
input.file <- rbind(c('R1','C1',1), c('R2','C1',1), c('R2','C2',1),
c('R3','C2',1), c('R4','C1',1))
res <- dcSparseMatrix(input.file)
res
# get a full matrix
as.matrix(res)
}
\seealso{
\code{\link{dcAlgoPredictMain}}
}

